% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Add.R
\name{Add}
\alias{Add}
\title{Adding xts together}
\usage{
Add(x, y, ...)
}
\arguments{
\item{x, y}{Input time series}

\item{...}{further time series to be added}
}
\description{
Adding xts together while treating NAs as zeros.
}
\details{
Sometimes, if a xts contains missing values, the behaviour of the usual addition-function is not ideal, 
at least for the purposes of seasonal adjustment of daily time series. This function changes the behaviour.
}
\examples{
series1 <- xts::xts(rnorm(5, 5, 5), seq.Date(from=as.Date("2010-01-01"), length.out=5, by="days"))
series2 <- xts::xts(c(3,4,NA, 6,7), seq.Date(from=as.Date("2010-01-01"), length.out=5, by="days"))
Add(series1, series2)
# Compare this to:
series1 + series2
}
\author{
Daniel Ollech
}
