% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.select.R
\name{ds.select}
\alias{ds.select}
\title{Keep or drop columns using their names and types}
\usage{
ds.select(df.name = NULL, tidy_expr = NULL, newobj = NULL, datasources = NULL)
}
\arguments{
\item{df.name}{Character specifying a serverside data frame or tibble.}

\item{tidy_expr}{List of one or more unquoted expressions separated by commas. Variable names can
be used as if they were positions in the data frame, so expressions like x:y can be used to
select a range of variables.}

\item{newobj}{Character specifying name for new server-side data frame.}

\item{datasources}{DataSHIELD connections object.}
}
\value{
No return value, called for its side effects. An object (typically a data frame or tibble)
with the name specified by \code{newobj} is created on the server.
}
\description{
DataSHIELD implentation of \code{dplyr::select}.
}
\examples{
\dontrun{
ds.select(
  df.name = "mtcars",
  tidy_expr = list(mpg, starts_with("t")),
  newobj = "df_subset",
  dataources = conns
)
}
}
