% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dosing_draw.R
\name{f_dosing_draw_t_1}
\alias{f_dosing_draw_t_1}
\title{Drug Dispensing Visit Dates for One Iteration}
\usage{
f_dosing_draw_t_1(
  i,
  fit_k0,
  fit_t0,
  fit_t1,
  fit_ki,
  fit_ti,
  vf_ongoing1,
  vf_new1
)
}
\arguments{
\item{i}{The iteration number.}

\item{fit_k0}{The model fit for the number of skipped
visits between randomization and the first drug dispensing visit.}

\item{fit_t0}{The model fit for the gap time between randomization
and the first drug dispensing visit when there is no visit skipping.}

\item{fit_t1}{The model fit for the gap time between randomization
and the first drug dispensing visit when there is visit skipping.}

\item{fit_ki}{The model fit for the number of skipped
visits between two consecutive drug dispensing visits.}

\item{fit_ti}{The model fit for the gap time between two
consecutive drug dispensing visits.}

\item{vf_ongoing1}{The last observed drug dispensing date for
ongoing patients, with or without the associated drug information.}

\item{vf_new1}{The randomization date for new patients and ongoing
patients with no drug dispensing records, with or without the
associated drug information.}
}
\value{
Drug dispensing visit dates at the subject level.
}
\description{
Obtains drug dispensing visit dates for one iteration.
}
\examples{

\donttest{
set.seed(431)
library(dplyr)

df <- df2 \%>\%
  mutate(arrivalTime = as.numeric(randdt - trialsdt + 1))

vf <- visitview2 \%>\%
  inner_join(df, by = "usubjid") \%>\%
  mutate(day = as.numeric(date - randdt + 1)) \%>\%
  select(drug, drug_name, dose_unit, usubjid, treatment,
         treatment_description, arrivalTime,
         time, event, dropout, day, dispensed_quantity) \%>\%
  group_by(drug, drug_name, dose_unit, usubjid, treatment,
           treatment_description, arrivalTime,
           time, event, dropout, day) \%>\%
  summarise(dose = sum(dispensed_quantity),
            .groups = "drop_last") \%>\%
  mutate(cum_dose = cumsum(dose)) \%>\%
  group_by(drug, drug_name, dose_unit, usubjid) \%>\%
  mutate(row_id = row_number())

pred <- eventPred::getPrediction(
  df = df,
  to_predict = "event only",
  target_d = 250,
  event_model = "log-logistic",
  dropout_model = "none",
  pilevel = 0.95,
  nyears = 3,
  nreps = 200,
  showsummary = FALSE,
  showplot = FALSE,
  by_treatment = TRUE)
newEvents <- pred$event_pred$newEvents

drug_name = drug_description_df$drug_name
dose_unit = drug_description_df$dose_unit
treatment_by_drug_df <- f_treatment_by_drug_df(
  treatment_by_drug, drug_name, dose_unit)

fit <- f_dispensing_models(
  target_days = dosing_schedule_df$target_days, vf,
  model_k0 = "zip", model_t0 = "log-logistic",
  model_ki = "zip", model_di = "lme",
  nreps = 200, showplot = FALSE)

trialsdt = df$trialsdt[1]
cutoffdt = df$cutoffdt[1]
t0 = as.numeric(cutoffdt - trialsdt + 1)
nyears = 3
t1 = t0 + nyears*365
t = c(seq(t0, t1, 30), t1)

nreps = length(unique(newEvents$draw))
l = length(unique(treatment_by_drug_df$drug))

# all ongoing subjects
df_unames1 <- df \%>\% filter(event == 0)
unames1 <- df_unames1$usubjid

# ongoing subjects with dosing records
df_unames2 <- vf \%>\% filter(event == 0) \%>\%
  group_by(usubjid) \%>\% slice(n())
unames2 <- df_unames2$usubjid

### dosing data for ongoing patients ###
vf1 <- vf \%>\%
  filter(usubjid \%in\% unames2) \%>\%
  select(drug, drug_name, dose_unit, usubjid, day, dose)

# replicate for nreps times
vf1_rep = tibble(draw = 1:nreps) \%>\% cross_join(vf1)

df1 <- newEvents \%>\%
  filter(usubjid \%in\% unames1) \%>\% select(-c(event, dropout))

vf_ongoing <- vf1_rep \%>\%
  inner_join(df1, by = c("draw", "usubjid"))

### new patients and ongoing patients with no dosing records ###
df_new <- newEvents \%>\%
  filter(arrivalTime > t0 | usubjid \%in\% setdiff(unames1, unames2))

vf_new <- purrr::map_dfr(
  1:l, function(h) {
    df_new \%>\%
      inner_join(treatment_by_drug_df \%>\% filter(drug == h),
                 by = "treatment") \%>\%
      select(-c(event, dropout))
  })

# only keep the last record for each patient in each draw
vf_ongoing1 <- vf_ongoing \%>\%
  group_by(draw, usubjid) \%>\% slice(n()) \%>\%
  mutate(V = day - 1,
         C = as.numeric(t0 - arrivalTime),
         D = pmin(time - 1, t1 - arrivalTime)) \%>\%
  select(-c(drug, drug_name, dose_unit, day, dose))

### new patients and ongoing patients with no dosing records ###
vf_new1 <- vf_new \%>\%
  group_by(draw, usubjid) \%>\% slice(n()) \%>\%
  mutate(V = 0,
         C = as.numeric(t0 - arrivalTime),
         D = pmin(time - 1, t1 - arrivalTime)) \%>\%
  select(-c(drug, drug_name, dose_unit))

dosing_subject_new1 <- f_dosing_draw_t_1(
  1, fit$fit_k0, fit$fit_t0, fit$fit_t1,
  fit$fit_ki, fit$fit_ti, vf_ongoing1, vf_new1)

head(dosing_subject_new1)
}

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
