% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dose_pp.R
\name{f_dose_pp}
\alias{f_dose_pp}
\title{Drug Demand Per Protocol}
\usage{
f_dose_pp(
  dosing_summary_t0,
  newEvents,
  treatment_by_drug_df,
  dosing_schedule_df,
  t0,
  t,
  pilevel
)
}
\arguments{
\item{dosing_summary_t0}{The cumulative doses dispensed
before the cutoff date. It contains the following variables:
\code{drug}, \code{drug_name}, \code{dose_unit},
and \code{cum_dose_t0}.}

\item{newEvents}{A data frame containing the imputed event data
for both ongoing and new patients, typically obtained from
the output of the \code{eventPred::getPrediction} function.
It contains the following variables:
\code{draw}, \code{usubjid}, \code{arrivalTime}, \code{treatment},
\code{treatment_description}, \code{time}, \code{event},
\code{dropout}, and \code{totalTime}.}

\item{treatment_by_drug_df}{A data frame indicating the treatments
associated with each drug, including the following variables:
\code{treatment}, \code{drug}, \code{drug_name}, and
\code{dose_unit}.}

\item{dosing_schedule_df}{A data frame providing dosing schedule
information. It contains the following variables: \code{drug},
\code{target_days}, \code{target_kits}, and \code{max_cycles}.}

\item{t0}{The cutoff date relative to the trial start date.}

\item{t}{A vector of new time points for drug dispensing predictions.}

\item{pilevel}{The prediction interval level.}
}
\value{
A data frame for dosing summary by drug and time point per
protocol. It contains the following variables:
\code{drug}, \code{drug_name}, \code{dose_unit}, \code{t}, \code{n},
\code{pilevel}, \code{lower}, \code{upper}, \code{mean},
and \code{var}.
}
\description{
Obtains drug demand prediction based on protocol-assumed
visit and dosing schedules.
}
\examples{

\donttest{
# Design stage drug demand predictions per protocol.

set.seed(312)
library(dplyr)

dosing_summary_t0 = drug_description_df \%>\%
  dplyr::mutate(cum_dose_t0 = 0)

pred <- eventPred::getPrediction(
  df = NULL,
  to_predict = "enrollment and event",
  target_n = 250,
  target_d = 250,
  enroll_prior = list(
    model = "piecewise poisson",
    theta = c(-0.74, -1.18),
    vtheta = matrix(c(0.0087, 0, 0, 0.0082), 2, 2),
    accrualTime = c(0, 240)),
  event_prior = list(
    list(model = "log-logistic",
         theta = c(5.9, -0.2),
         vtheta = matrix(c(0.022, 0.004, 0.004, 0.012), 2, 2)),
    list(model = "log-logistic",
         theta = c(5.6, 0.02),
         vtheta = matrix(c(0.032, 0.003, 0.003, 0.012), 2, 2)),
    list(model = "log-logistic",
         theta = c(5.7, -0.3),
         vtheta = matrix(c(0.071, 0.013, 0.013, 0.054), 2, 2))),
  dropout_prior = NULL,
  pilevel = 0.95,
  nyears = 3,
  nreps = 200,
  showsummary = FALSE,
  showplot = FALSE,
  by_treatment = TRUE,
  ngroups = 3,
  alloc = c(2, 2, 1),
  treatment_label = c("Drug A + Drug B",
                      "Drug C + Placebo",
                      "Drug A + Placebo"))

newEvents <- pred$event_pred$newEvents

drug_name = drug_description_df$drug_name
dose_unit = drug_description_df$dose_unit
treatment_by_drug_df <- f_treatment_by_drug_df(
  treatment_by_drug, drug_name, dose_unit)

t0 = 1
nyears = 3
t1 = t0 + nyears*365
t = c(seq(t0, t1, 30), t1)
pilevel = 0.95

dosing_pred_pp <- f_dose_pp(
  dosing_summary_t0, newEvents,
  treatment_by_drug_df, dosing_schedule_df,
  t0, t, pilevel)

head(dosing_pred_pp)
}

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
