% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_funs.R
\name{ifsingle}
\alias{ifsingle}
\alias{ifunit}
\title{Conditional element selection}
\usage{
ifsingle(x, yes, no)

ifunit(x, yes, no)
}
\arguments{
\item{x}{A vector (\code{ifsingle}) or a numeric of length 1 (\code{ifunit}).}

\item{yes}{Something of length 1. Result if the condition is fulfilled.}

\item{no}{Something of length 1. Result if the condition is not fulfilled.}
}
\value{
Returns something of length 1.
}
\description{
Tiny functions shorter, and hopefully more explicit, than \code{ifelse}.
}
\details{
Yes, \code{ifunit} is identical to \code{ifelse(test == 1, yes, no)}. And regarding \code{ifsingle}, it is identical to \code{ifelse(length(test) == 1, yes, no)}.

Why writing these functions then? Actually, I've found that they make the code more explicit, and this helps!
}
\section{Functions}{
\itemize{
\item \code{ifunit()}: Conditional element selection depending on whether \code{x} is equal to unity or not.

}}
\examples{

# Let's create an error message when NAs are present
my_crossprod = function(mat){
 if(anyNA(mat)){
   row_na = which(rowSums(is.na(mat)) > 0)
   n_na = length(row_na)
   stop("In argument 'mat': ", n_letter(n_na), " row", plural(n_na, "s.contain"),
        " NA values (", ifelse(n_na<=3, "", "e.g. "), "row",
        enumerate_items(head(row_na, 3), "s"), ").
        Please remove ", ifunit(n_na, "it", "them"), " first.")
 }
 crossprod(mat)
}

mat = matrix(rnorm(30), 10, 3)
mat4 = mat1 = mat
mat4[c(1, 7, 13, 28)] = NA
mat1[7] = NA

# Error raised because of NA: informative (and nice) messages
try(my_crossprod(mat4))
try(my_crossprod(mat1))


}
\author{
Laurent Berge
}
