% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop.R
\name{check_expr}
\alias{check_expr}
\alias{check_expr_hook}
\alias{generate_check_expr_hook}
\title{Checks the evaluation of an expression}
\usage{
check_expr(expr, ..., clean, up = 0, arg_name, verbatim = FALSE)

check_expr_hook(expr, ..., clean, arg_name, verbatim = FALSE)

generate_check_expr_hook(namespace)
}
\arguments{
\item{expr}{An expression to be evaluated.}

\item{...}{Character scalars. The values of \code{...} will be coerced with the function
\href{https://lrberge.github.io/stringmagic/articles/guide_string_magic.html}{string_magic}.
This means that string interpolation is allowed. Ex: \code{"Arg. {arg} should be positive"}
leads to \code{"Arg. power should be positive"} if \code{arg} is equal to "power".

If argument \code{verbatim} is \code{TRUE}, the values are instead coereced with \code{paste0}.}

\item{clean}{Character vector, default is missing. If provided, the function
\href{https://lrberge.github.io/stringmagic/reference/string_clean.html}{\code{string_clean}}
is applied to the \emph{captured error message} to clean it when necessary. Each element
of the vector should be of the form \code{"pat => rep"} with pat a regular expression
to be replace and \code{rep} the replacement.}

\item{up}{Integer, default is 0. It is used to construct the call in the error message.
By default the call reported is the function containing \code{check_expr}. If you want to
report a function higher in the stack, use \code{up = 1}, or higher.}

\item{arg_name}{Character scalar, default is missing. Used when the expression in
\code{expr} leads to an error and the custom message is missing (i.e. no element is
provided in \code{...}). In that case, the default message is: "The argument \verb{\{}arg_name\verb{\}} could not be evaluated.".
The default value for \code{arg_name} is \code{deparse(substitute(expr))}, if this guess is wrong,
use \code{arg_name}.}

\item{verbatim}{Logical scalar, default is \code{FALSE}. By default the elements of \code{...}
allow string interpolation with "\code{{}}" using \href{https://github.com/lrberge/stringmagic}{stringmagic}.
If \code{TRUE}, no interpolation is performed.}

\item{namespace}{Character scalar giving the namespace for which the hooks are valid. Only useful
when hook functions are used in a package.}
}
\description{
This functions checks the evaluation of an expression and, if an error is thrown,
captures it and integrates the captured message after a custom error message.
}
\details{
The purpose of this functions is to provide useful error messages to the user.
}
\section{Functions}{
\itemize{
\item \code{check_expr_hook()}: As \code{check_expr} but sets the error call at the level of the hooked function

\item \code{generate_check_expr_hook()}: Generates a package specific \code{check_expr_hook} function

}}
\examples{

test = function(x, y){
  check_expr(mean(x, y), "Computing the mean didn't work:")
}


}
\seealso{
For general argument checking, see \code{\link[=check_arg]{check_arg()}} and \code{\link[=check_set_arg]{check_set_arg()}}.
}
\author{
Laurent Berge
}
