% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model}
\alias{model}
\alias{model_linear}
\alias{model_quad}
\alias{model_loglinear}
\alias{model_logquad}
\alias{model_emax}
\alias{model_exp}
\alias{model_beta}
\alias{model_independent}
\alias{model_linear_binary}
\alias{model_quad_binary}
\alias{model_loglinear_binary}
\alias{model_logquad_binary}
\alias{model_emax_binary}
\alias{model_exp_binary}
\alias{model_beta_binary}
\alias{model_independent_binary}
\title{Model Creation}
\usage{
model_linear(
  mu_b1,
  sigma_b1,
  mu_b2,
  sigma_b2,
  shape,
  rate,
  w_prior = 1,
  longitudinal = NULL
)

model_quad(
  mu_b1,
  sigma_b1,
  mu_b2,
  sigma_b2,
  mu_b3,
  sigma_b3,
  shape,
  rate,
  w_prior = 1,
  longitudinal = NULL
)

model_loglinear(
  mu_b1,
  sigma_b1,
  mu_b2,
  sigma_b2,
  shape,
  rate,
  w_prior = 1,
  longitudinal = NULL
)

model_logquad(
  mu_b1,
  sigma_b1,
  mu_b2,
  sigma_b2,
  mu_b3,
  sigma_b3,
  shape,
  rate,
  w_prior = 1,
  longitudinal = NULL
)

model_emax(
  mu_b1,
  sigma_b1,
  mu_b2,
  sigma_b2,
  mu_b3,
  sigma_b3,
  mu_b4,
  sigma_b4,
  shape,
  rate,
  w_prior = 1,
  longitudinal = NULL
)

model_exp(
  mu_b1,
  sigma_b1,
  mu_b2,
  sigma_b2,
  mu_b3,
  sigma_b3,
  shape,
  rate,
  w_prior = 1,
  longitudinal = NULL
)

model_beta(
  mu_b1,
  sigma_b1,
  mu_b2,
  sigma_b2,
  mu_b3,
  sigma_b3,
  mu_b4,
  sigma_b4,
  shape,
  rate,
  scale = NULL,
  w_prior = 1,
  longitudinal = NULL
)

model_independent(
  mu_b1,
  sigma_b1,
  shape,
  rate,
  doses = NULL,
  w_prior = 1,
  longitudinal = NULL
)

model_linear_binary(
  mu_b1,
  sigma_b1,
  mu_b2,
  sigma_b2,
  link,
  w_prior = 1,
  longitudinal = NULL
)

model_quad_binary(
  mu_b1,
  sigma_b1,
  mu_b2,
  sigma_b2,
  mu_b3,
  sigma_b3,
  link,
  w_prior = 1,
  longitudinal = NULL
)

model_loglinear_binary(
  mu_b1,
  sigma_b1,
  mu_b2,
  sigma_b2,
  link,
  w_prior = 1,
  longitudinal = NULL
)

model_logquad_binary(
  mu_b1,
  sigma_b1,
  mu_b2,
  sigma_b2,
  mu_b3,
  sigma_b3,
  link,
  w_prior = 1,
  longitudinal = NULL
)

model_emax_binary(
  mu_b1,
  sigma_b1,
  mu_b2,
  sigma_b2,
  mu_b3,
  sigma_b3,
  mu_b4,
  sigma_b4,
  link,
  w_prior = 1,
  longitudinal = NULL
)

model_exp_binary(
  mu_b1,
  sigma_b1,
  mu_b2,
  sigma_b2,
  mu_b3,
  sigma_b3,
  link,
  w_prior = 1,
  longitudinal = NULL
)

model_beta_binary(
  mu_b1,
  sigma_b1,
  mu_b2,
  sigma_b2,
  mu_b3,
  sigma_b3,
  mu_b4,
  sigma_b4,
  scale = NULL,
  link,
  w_prior = 1,
  longitudinal = NULL
)

model_independent_binary(
  mu_b1,
  sigma_b1,
  doses = NULL,
  link,
  w_prior = 1,
  longitudinal = NULL
)
}
\arguments{
\item{mu_b1, sigma_b1, mu_b2, sigma_b2, mu_b3, sigma_b3, mu_b4, sigma_b4, shape, rate}{models parameters.  See sections below for interpretation in
specific models.}

\item{w_prior}{a scalar between 0 and 1 indicating the prior weight of the
model.}

\item{longitudinal}{output from a call to one of the model_longitudinal_*()
functions.  This is used to specify a longitudinal dose-response model.}

\item{scale}{a scale parameter in the Beta model. Default is 1.2 * max(dose).}

\item{doses}{the doses in the dataset to be modeled.  The order of the
doses corresponds to the order in which the priors are specified in
\code{mu_b1} and \code{sigma_b1}.}

\item{link}{a character string of either "logit" or "probit" indicating
the link function for binary model.}
}
\value{
A named list of the arguments in the function call.  The list has
S3 classes assigned which are used internally within \code{dreamer_mcmc()}.
}
\description{
Functions which set the hyperparameters, seeds, and prior
weight for each model to be used in Bayesian model averaging
via \code{dreamer_mcmc()}.

See each function's section below for the model's details.  In the
following, \eqn{y} denotes the response variable and \eqn{d} represents
the dose.

For the longitudinal specifications, see documentation on
\code{\link{model_longitudinal}}.
}
\section{Linear}{

\deqn{y \sim N(f(d), \sigma^2)}
\deqn{f(d) = b_1 + b_2 * d}
\deqn{b_1 \sim N(mu_b1, sigma_b1 ^ 2)}
\deqn{b_2 \sim N(mu_b2, sigma_b2 ^ 2)}
\deqn{1 / \sigma^2 \sim Gamma(shape, rate)}
}

\section{Quadratic}{

\deqn{y \sim N(f(d), \sigma^2)}
\deqn{f(d) = b_1 + b_2 * d + b_3 * d^2}
\deqn{b_1 \sim N(mu_b1, sigma_b1 ^ 2)}
\deqn{b_2 \sim N(mu_b2, sigma_b2 ^ 2)}
\deqn{b_3 \sim N(mu_b3, sigma_b3 ^ 2)}
\deqn{1 / \sigma^2 \sim Gamma(shape, rate)}
}

\section{Log-linear}{

\deqn{y \sim N(f(d), \sigma^2)}
\deqn{f(d) = b_1 + b_2 * log(d + 1)}
\deqn{b_1 \sim N(mu_b1, sigma_b1 ^ 2)}
\deqn{b_2 \sim N(mu_b2, sigma_b2 ^ 2)}
\deqn{1 / \sigma^2 \sim Gamma(shape, rate)}
}

\section{Log-quadratic}{

\deqn{y \sim N(f(d), \sigma^2)}
\deqn{f(d) = b_1 + b_2 * log(d + 1) + b_3 * log(d + 1)^2}
\deqn{b_1 \sim N(mu_b1, sigma_b1 ^ 2)}
\deqn{b_2 \sim N(mu_b2, sigma_b2 ^ 2)}
\deqn{b_3 \sim N(mu_b3, sigma_b3 ^ 2)}
\deqn{1 / \sigma^2 \sim Gamma(shape, rate)}
}

\section{EMAX}{

\deqn{y \sim N(f(d), \sigma^2)}
\deqn{f(d) = b_1 + (b_2 - b_1) * d ^ b_4 / (exp(b_3 * b_4) + d ^ b_4)}
\deqn{b_1 \sim N(mu_b1, sigma_b1 ^ 2)}
\deqn{b_2 \sim N(mu_b2, sigma_b2 ^ 2)}
\deqn{b_3 \sim N(mu_b3, sigma_b3 ^ 2)}
\deqn{b_4 \sim N(mu_b4, sigma_b4 ^ 2), (Truncated above 0)}
\deqn{1 / \sigma^2 \sim Gamma(shape, rate)}
Here, \eqn{b_1} is the placebo effect (dose = 0), \eqn{b_2} is the
maximum treatment effect, \eqn{b_3} is the \eqn{log(ED50)}, and
\eqn{b_4} is the hill or rate parameter.
}

\section{Exponential}{

\deqn{y \sim N(f(d), \sigma^2)}
\deqn{f(d) = b_1 + b_2 * (1 - exp(- b_3 * d))}
\deqn{b_1 \sim N(mu_b1, sigma_b1 ^ 2)}
\deqn{b_2 \sim N(mu_b2, sigma_b2 ^ 2)}
\deqn{b_3 \sim N(mu_b3, sigma_b3 ^ 2), (truncated to be positive)}
\deqn{1 / \sigma^2 \sim Gamma(shape, rate)}
}

\section{Beta}{

\deqn{y \sim N(f(d), \sigma^2)}
\deqn{f(d) = b_1 + b_2 * ((b3 + b4) ^ (b3 + b4)) /
    (b3 ^ b3 * b4 ^ b4) * (d / scale) ^ b3 *
    (1 - d / scale) ^ b4}
\deqn{b_1 \sim N(mu_b1, sigma_b1 ^ 2)}
\deqn{b_2 \sim N(mu_b2, sigma_b2 ^ 2)}
\deqn{b_3 \sim N(mu_b3, sigma_b3 ^ 2), Truncated above 0}
\deqn{b_4 \sim N(mu_b4, sigma_b4 ^ 2), Truncated above 0}
\deqn{1 / \sigma^2 \sim Gamma(shape, rate)}
Note that \eqn{scale} is a hyperparameter specified by the
user.
}

\section{Independent}{

\deqn{y \sim N(f(d), \sigma^2)}
\deqn{f(d) = b_{1d}}
\deqn{b_{1d} \sim N(mu_b1[d], sigma_b1[d] ^ 2)}
\deqn{1 / \sigma^2 \sim Gamma(shape, rate)}
}

\section{Independent Details}{

The independent model models the effect of each dose independently.
Vectors can be supplied to \code{mu_b1} and \code{sigma_b1} to set a different
prior for each dose in the order the doses are supplied to \code{doses}.
If scalars are supplied to \code{mu_b1} and \code{sigma_b1}, then the same prior
is used for each dose, and the \code{doses} argument is not needed.
}

\section{Linear Binary}{

\deqn{y \sim Binomial(n, f(d))}
\deqn{link(f(d)) = b_1 + b_2 * d}
\deqn{b_1 \sim N(mu_b1, sigma_b1 ^ 2)}
\deqn{b_2 \sim N(mu_b2, sigma_b2 ^ 2)}
}

\section{Quadratic Binary}{

\deqn{y \sim Binomial(n, f(d))}
\deqn{link(f(d)) = b_1 + b_2 * d + b_3 * d^2}
\deqn{b_1 \sim N(mu_b1, sigma_b1 ^ 2)}
\deqn{b_2 \sim N(mu_b2, sigma_b2 ^ 2)}
\deqn{b_3 \sim N(mu_b3, sigma_b3 ^ 2)}
}

\section{Log-linear Binary}{

\deqn{y \sim Binomial(n, f(d))}
\deqn{link(f(d)) = b_1 + b_2 * log(d + 1)}
\deqn{b_1 \sim N(mu_b1, sigma_b1 ^ 2)}
\deqn{b_2 \sim N(mu_b2, sigma_b2 ^ 2)}
}

\section{Log-quadratic Binary}{

\deqn{y \sim Binomial(n, f(d))}
\deqn{link(f(d)) = b_1 + b_2 * log(d + 1) + b_3 * log(d + 1)^2}
\deqn{b_1 \sim N(mu_b1, sigma_b1 ^ 2)}
\deqn{b_2 \sim N(mu_b2, sigma_b2 ^ 2)}
\deqn{b_3 \sim N(mu_b3, sigma_b3 ^ 2)}
}

\section{EMAX Binary}{

\deqn{y \sim Binomial(n, f(d))}
\deqn{link(f(d)) = b_1 + (b_2 - b_1) * d ^ b_4 /
    (exp(b_3 * b_4) + d ^ b_4)}
\deqn{b_1 \sim N(mu_b1, sigma_b1 ^ 2)}
\deqn{b_2 \sim N(mu_b2, sigma_b2 ^ 2)}
\deqn{b_3 \sim N(mu_b3, sigma_b3 ^ 2)}
\deqn{b_4 \sim N(mu_b4, sigma_b4 ^ 2), (Truncated above 0)}
Here, on the \eqn{link(f(d))} scale,
\eqn{b_1} is the placebo effect (dose = 0), \eqn{b_2} is the
maximum treatment effect, \eqn{b_3} is the \eqn{log(ED50)}, and
\eqn{b_4} is the hill or rate parameter.
}

\section{Exponential Binary}{

\deqn{y \sim Binomial(n, f(d))}
\deqn{link(f(d)) = b_1 + b_2 * (exp(b_3 * d) - 1)}
\deqn{b_1 \sim N(mu_b1, sigma_b1 ^ 2)}
\deqn{b_2 \sim N(mu_b2, sigma_b2 ^ 2)}
\deqn{b_3 \sim N(mu_b3, sigma_b3 ^ 2), (Truncated below 0)}
}

\section{Beta Binary}{

\deqn{y \sim Binomial(n, f(d)}
\deqn{link(f(d)) = b_1 + b_2 * ((b3 + b4) ^ (b3 + b4)) /
    (b3 ^ b3 * b4 ^ b4) * (d / scale) ^ b3 *
    (1 - d / scale) ^ b4}
\deqn{b_1 \sim N(mu_b1, sigma_b1 ^ 2)}
\deqn{b_2 \sim N(mu_b2, sigma_b2 ^ 2)}
\deqn{b_3 \sim N(mu_b3, sigma_b3 ^ 2), Truncated above 0}
\deqn{b_4 \sim N(mu_b4, sigma_b4 ^ 2), Truncated above 0}
Note that \eqn{scale} is a hyperparameter specified by the
user.
}

\section{Independent Binary}{

\deqn{y \sim Binomial(n, f(d))}
\deqn{link(f(d)) = b_{1d}}
\deqn{b_{1d} \sim N(mu_b1[d], sigma_b1[d]) ^ 2}
}

\section{Independent Binary Details}{

The independent model models the effect of each dose independently.
Vectors can be supplied to \code{mu_b1} and \code{sigma_b1} to set a different
prior for each dose in the order the doses are supplied to \code{doses}.
If scalars are supplied to \code{mu_b1} and \code{sigma_b1}, then the same prior
is used for each dose, and the \code{doses} argument is not needed.
}

\section{Longitudinal Linear}{

Let \eqn{f(d)} be a dose response model.  The expected value of the
response, y, is:
\deqn{E(y) = g(d, t)}
\deqn{g(d, t) = a + (t / t_max) * f(d)}
\deqn{a \sim N(mu_a, sigma_a)}
}

\section{Longitudinal ITP}{

Let \eqn{f(d)} be a dose response model.  The expected value of the
response, y, is:
\deqn{E(y) = g(d, t)}
\deqn{g(d, t) = a + f(d) * ((1 - exp(- c1 * t))/(1 - exp(- c1 * t_max)))}
\deqn{a \sim N(mu_a, sigma_a)}
\deqn{c1 \sim Uniform(a_c1, b_c1)}
}

\section{Longitudinal IDP}{

Increasing-Decreasing-Plateau (IDP).

Let \eqn{f(d)} be a dose response model.  The expected value of the
response, y, is:
\deqn{E(y) = g(d, t)}
\deqn{g(d, t) = a + f(d) * (((1 - exp(- c1 * t))/(1 - exp(- c1 * d1))) *
    I(t < d1) + (1 - gam * ((1 - exp(- c2 * (t - d1))) /
    (1 - exp(- c2 * (d2 - d1))))) *
    I(d1 <= t <= d2) + (1 - gam) * I(t > d2))}
\deqn{a \sim N(mu_a, sigma_a)}
\deqn{c1 \sim Uniform(a_c1, b_c1)}
\deqn{c2 \sim Uniform(a_c2, b_c2)}
\deqn{d1 \sim Uniform(0, t_max)}
\deqn{d2 \sim Uniform(d1, t_max)}
\deqn{gam \sim Uniform(0, 1)}
}

\examples{
set.seed(888)
data <- dreamer_data_linear(
  n_cohorts = c(20, 20, 20),
  dose = c(0, 3, 10),
  b1 = 1,
  b2 = 3,
  sigma = 5
)

# Bayesian model averaging
output <- dreamer_mcmc(
  data = data,
  n_adapt = 1e3,
  n_burn = 1e2,
  n_iter = 1e3,
  n_chains = 2,
  silent = TRUE,
  mod_linear = model_linear(
    mu_b1 = 0,
    sigma_b1 = 1,
    mu_b2 = 0,
    sigma_b2 = 1,
    shape = 1,
    rate = .001,
    w_prior = 1 / 2
  ),
  mod_quad = model_quad(
    mu_b1 = 0,
    sigma_b1 = 1,
    mu_b2 = 0,
    sigma_b2 = 1,
    mu_b3 = 0,
    sigma_b3 = 1,
    shape = 1,
    rate = .001,
    w_prior = 1 / 2
  )
)
# posterior weights
output$w_post
# plot posterior dose response
plot(output)

# LONGITUDINAL
library(ggplot2)
set.seed(889)
data_long <- dreamer_data_linear(
  n_cohorts = c(10, 10, 10, 10), # number of subjects in each cohort
  doses = c(.25, .5, .75, 1.5), # dose administered to each cohort
  b1 = 0, # intercept
  b2 = 2, # slope
  sigma = .5, # standard deviation,
  longitudinal = "itp",
  times = c(0, 12, 24, 52),
  t_max = 52, # maximum time
  a = .5,
  c1 = .1
)

\dontrun{
ggplot(data_long, aes(time, response, group = dose, color = factor(dose))) +
   geom_point()
}

output_long <- dreamer_mcmc(
   data = data_long,
   n_adapt = 1e3,
   n_burn = 1e2,
   n_iter = 1e3,
   n_chains = 2,
   silent = TRUE, # make rjags be quiet,
   mod_linear = model_linear(
      mu_b1 = 0,
      sigma_b1 = 1,
      mu_b2 = 0,
      sigma_b2 = 1,
      shape = 1,
      rate = .001,
      w_prior = 1 / 2, # prior probability of the model
      longitudinal = model_longitudinal_itp(
         mu_a = 0,
         sigma_a = 1,
         a_c1 = 0,
         b_c1 = 1,
         t_max = 52
      )
   ),
   mod_quad = model_quad(
      mu_b1 = 0,
      sigma_b1 = 1,
      mu_b2 = 0,
      sigma_b2 = 1,
      mu_b3 = 0,
      sigma_b3 = 1,
      shape = 1,
      rate = .001,
      w_prior = 1 / 2,
      longitudinal = model_longitudinal_linear(
         mu_a = 0,
         sigma_a = 1,
         t_max = 52
      )
   )
)

\dontrun{
# plot longitudinal dose-response profile
plot(output_long, data = data_long)
plot(output_long$mod_quad, data = data_long) # single model

# plot dose response at final timepoint
plot(output_long, data = data_long, times = 52)
plot(output_long$mod_quad, data = data_long, times = 52) # single model
}
}
