% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz.R
\name{gompertz_fn}
\alias{gompertz_fn}
\title{Gompertz function}
\usage{
gompertz_fn(x, theta)
}
\arguments{
\item{x}{numeric vector at which the Gompertz function is to be evaluated.}

\item{theta}{numeric vector with the four parameters in the form
\code{c(alpha, beta, eta, phi)}.}
}
\value{
Numeric vector of the same length of \code{x} with the values of the
Gompertz function.
}
\description{
Evaluate at a particular set of parameters the Gompertz function.
}
\details{
The Gompertz function \verb{f(x; theta)} is defined here as

\verb{alpha + (beta - alpha) exp(-exp(-eta * (x - phi)))}

where \code{theta = c(alpha, beta, eta, phi)}, \code{alpha} is the lower horizontal
asymptote, \code{beta > alpha} is the upper horizontal asymptote, \code{eta} is the
steepness of the curve or growth rate, and \code{phi} related to the function
value at \code{x = 0}.
}
