% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpF.R
\name{dpseudoF}
\alias{dpseudoF}
\title{double pseudoF (Calinski-Harabsz) index}
\usage{
dpseudoF(data, maxK, maxQ)
}
\arguments{
\item{data}{Units x variables numeric data matrix.}

\item{maxK}{Maximum number of clusters for the units to be tested.}

\item{maxQ}{Maximum number of clusters for the variables to be tested.}
}
\value{
\item{dpseudoF}{matrix containing the pF value for each pair of K and Q within the specified range}
}
\description{
A pseudoF version for double partitioning, for the choice of the number of clusters of the units and variables (rows and columns of the data matrix). It is a diagnostic tool for inspecting simultaneously the optimal number of unit-clusters and variable-clusters.
}
\examples{
# Iris data 
# Loading the numeric variables of iris data
iris <- as.matrix(iris[,-5]) 

dpeudoF <- dpseudoF(iris, maxK=10, maxQ = 3)

}
\references{
R. Rocci, M. Vichi (2008)" Two-mode multi-partitioning" <doi:10.1016/j.csda.2007.06.025>


T. Calinski & J. Harabasz (1974). A dendrite method for cluster analysis. Communications in Statistics, 3:1, 1-27
}
\author{
Ionel Prunila, Maurizio Vichi
}
