% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{toCanvasBtn}
\alias{toCanvasBtn}
\title{Screenshot HTML elements to canvas button}
\usage{
toCanvasBtn(
  dom,
  canvasID,
  isID = TRUE,
  id = "",
  label = "To Canvas",
  color_class = "primary"
)
}
\arguments{
\item{dom}{a HTML DOM selector, mostly common is to select the element by ID:
e.g. a plot with ID "plot1", to select, use \code{dom = "plot1"} to select the plot if
\code{isID = TRUE}. If \code{isID = FALSE}, use \code{dom = "#plot1"}

Other complex selector is supported. First turn \code{isID = FALSE}, then try things
like \code{dom = ".btn i"} selects an icon inside an element
with "btn" class. If more than one element is matched, only the first one will
be screenshoted.}

\item{canvasID}{string, the ID of canvas. Unlike \code{dom}, you should not add
"#" for \code{canvasID} even if \code{isID=FALSE}}

\item{isID}{bool, \code{TRUE} if you want to select the \code{dom} by HTML ID, \code{FALSE}
if the selector is other than ID.}

\item{id}{string, ID for this button, optional}

\item{label}{label of this button, optional}

\item{color_class}{bootstrap button color class suffix, usually one of
'default', 'primary', 'info', 'success', 'warning', 'danger'}
}
\value{
a button
}
\description{
A bootstrap button that allows users to take a screenshot of
specified HTML element (usually an image) and send it to the drawer canvas
for editing. In addition, you can download it as "png" or "jpg" by opening
up the dropdown menu.
}
\details{
This component will not work unless a drawer canvas has been loaded
on current document.
}
\examples{
# see example of "canvas", `?canvas`
}
