% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpc.R
\name{drake_hpc_template_files}
\alias{drake_hpc_template_files}
\title{List the available example template files for deploying
work to a cluster / job scheduler.
\lifecycle{stable}}
\usage{
drake_hpc_template_files()
}
\value{
A character vector of example template files that
you can write with \code{\link[=drake_hpc_template_file]{drake_hpc_template_file()}}.
}
\description{
See the example files from
\code{\link[=drake_examples]{drake_examples()}} and \code{\link[=drake_example]{drake_example()}}
for example usage.
}
\examples{
\dontrun{
plan <- drake_plan(x = rnorm(1e7), y = rnorm(1e7))
# List the available template files.
drake_hpc_template_files()
# Write a SLURM template file.
out <- file.path(tempdir(), "slurm_batchtools.tmpl")
drake_hpc_template_file("slurm_batchtools.tmpl", to = tempdir())
cat(readLines(out), sep = "\\n")
# library(future.batchtools) # nolint
# future::plan(batchtools_slurm, template = out) # nolint
# make(plan, parallelism = "future", jobs = 2) # nolint
}
}
\seealso{
\code{\link[=drake_hpc_template_file]{drake_hpc_template_file()}},
\code{\link[=drake_examples]{drake_examples()}}, \code{\link[=drake_example]{drake_example()}},
\code{\link[=shell_file]{shell_file()}}
}
