% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-deprecate.R
\name{evaluate_plan}
\alias{evaluate_plan}
\title{Deprecated: use wildcard templating to create a
workflow plan data frame from a template data frame.}
\usage{
evaluate_plan(plan, rules = NULL, wildcard = NULL, values = NULL,
  expand = TRUE, rename = expand, trace = FALSE,
  columns = "command", sep = "_")
}
\arguments{
\item{plan}{Workflow plan data frame, similar to one produced by
\code{\link[=drake_plan]{drake_plan()}}.}

\item{rules}{Named list with wildcards as names and vectors of
replacements
as values. This is a way to evaluate multiple wildcards at once.
When not \code{NULL}, \code{rules} overrules \code{wildcard} and
\code{values} if
not \code{NULL}.}

\item{wildcard}{Character scalar denoting a wildcard placeholder.}

\item{values}{Vector of values to replace the wildcard
in the drake instructions. Will be treated as a character vector.
Must be the same length as \code{plan$command} if \code{expand} is
\code{TRUE}.}

\item{expand}{If \code{TRUE}, create a new rows in the workflow plan
data frame
if multiple values are assigned to a single wildcard.
If \code{FALSE}, each occurrence of the wildcard
is replaced with the next entry in the \code{values} vector,
and the values are recycled.}

\item{rename}{Logical, whether to rename the targets
based on the values supplied for the wildcards
(based on \code{values} or \code{rules}).}

\item{trace}{Logical, whether to add columns that
trace the wildcard expansion process. These new
columns indicate which targets were evaluated and with which
wildcards.}

\item{columns}{Character vector of names of columns
to look for and evaluate the wildcards.}

\item{sep}{Character scalar, separator for the names
of the new targets generated. For example, in
\code{evaluate_plan(drake_plan(x = sqrt(y__)), list(y__ = 1:2), sep = ".")},
the names of the new targets are \code{x.1} and \code{x.2}.}
}
\value{
A workflow plan data frame with the wildcards evaluated.
}
\description{
Deprecated on 2019-05-16. Use \code{\link[=drake_plan]{drake_plan()}}
transformations instead. See
\url{https://ropenscilabs.github.io/drake-manual/plans.html#large-plans}
for the details.
}
\details{
The commands in workflow plan data frames can have
wildcard symbols that can stand for datasets, parameters, function
arguments, etc. These wildcards can be evaluated over a set of
possible values using \code{evaluate_plan()}.

Specify a single wildcard with the \code{wildcard}
and \code{values} arguments. In each command, the text in
\code{wildcard} will be replaced by each value in \code{values}
in turn. Specify multiple wildcards with the \code{rules} argument,
which overrules \code{wildcard} and \code{values} if
not \code{NULL}. Here, \code{rules} should be a list with wildcards
as names and vectors of possible values as list elements.
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}
}
\keyword{internal}
