% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_build.R
\name{drake_debug}
\alias{drake_debug}
\title{Run a single target's command in debug mode.'
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}}
\usage{
drake_debug(
  target = NULL,
  ...,
  character_only = FALSE,
  replace = FALSE,
  verbose = TRUE,
  config = NULL
)
}
\arguments{
\item{target}{Name of the target.}

\item{...}{Arguments to \code{\link[=make]{make()}}, such as the plan and environment.}

\item{character_only}{Logical, whether \code{name} should be treated
as a character or a symbol
(just like \code{character.only} in \code{\link[=library]{library()}}).}

\item{replace}{Logical. If \code{FALSE},
items already in your environment
will not be replaced.}

\item{verbose}{Logical, whether to print out the target
you are debugging.}

\item{config}{Deprecated 2019-12-22.}
}
\value{
The value of the target right after it is built.
}
\description{
Not valid for dynamic branching.
\code{drake_debug()} loads a target's dependencies
and then runs its command in debug mode (see \code{browser()},
\code{debug()}, and \code{debugonce()}). This function does not
store the target's value in the cache
(see \url{https://github.com/ropensci/drake/issues/587}).
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
# This example is not really a user-side demonstration.
# It just walks through a dive into the internals.
# Populate your workspace and write 'report.Rmd'.
load_mtcars_example() # Get the code with drake_example("mtcars").
# out <- drake_debug(small, my_plan)
# `small` was invisibly returned.
# head(out)
}
})
}
}
\seealso{
\code{\link[=drake_build]{drake_build()}}
}
