% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_plan_helpers.R
\name{target}
\alias{target}
\title{Customize a target in \code{\link[=drake_plan]{drake_plan()}}.
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}}
\usage{
target(command = NULL, transform = NULL, dynamic = NULL, ...)
}
\arguments{
\item{command}{The command to build the target.}

\item{transform}{A call to \code{\link[=map]{map()}}, \code{\link[=split]{split()}}, \code{\link[=cross]{cross()}}, or \code{\link[=combine]{combine()}}
to apply a \emph{static} transformation. Details:
\url{https://books.ropensci.org/drake/static.html}}

\item{dynamic}{A call to \code{\link[=map]{map()}}, \code{\link[=cross]{cross()}}, or \code{\link[=group]{group()}}
to apply a \emph{dynamic} transformation. Details:
\url{https://books.ropensci.org/drake/dynamic.html}}

\item{...}{Optional columns of the plan for a given target.
See the Columns section of this help file for a selection
of special columns that \code{drake} understands.}
}
\value{
A one-row workflow plan data frame with the named
arguments as columns.
}
\description{
The \code{target()} function is a way to
configure individual targets in a \code{drake} plan.
Its most common use is to invoke static branching
and dynamic branching, and it can also set the values
of custom columns such as \code{format}, \code{elapsed}, \code{retries},
and \code{max_expand}. Details are at
\url{https://books.ropensci.org/drake/plans.html#special-columns}.
Note: \code{drake_plan(my_target = my_command())}
is equivalent to
\verb{drake_plan(my_target = target(my_command())}.
}
\details{
\code{target()} must be called inside \code{\link[=drake_plan]{drake_plan()}}.
It is invalid otherwise.
}
\section{Columns}{

\code{\link[=drake_plan]{drake_plan()}} creates a special data frame. At minimum, that data frame
must have columns \code{target} and \code{command} with the target names and the
R code chunks to build them, respectively.

You can add custom columns yourself, either with \code{target()} (e.g.
\code{drake_plan(y = target(f(x), transform = map(c(1, 2)), format = "fst"))})
or by appending columns post-hoc (e.g. \code{plan$col <- vals}).

Some of these custom columns are special. They are optional,
but \code{drake} looks for them at various points in the workflow.
\itemize{
\item \code{transform}: a call to \code{\link[=map]{map()}}, \code{\link[=split]{split()}}, \code{\link[=cross]{cross()}}, or
\code{\link[=combine]{combine()}} to create and manipulate large collections of targets.
Details: (\url{https://books.ropensci.org/drake/plans.html#large-plans}). # nolint
\item \code{format}: set a storage format to save big targets more efficiently.
See the "Formats" section of this help file for more details.
\item \code{trigger}: rule to decide whether a target needs to run.
It is recommended that you define this one with \code{target()}.
Details: \url{https://books.ropensci.org/drake/triggers.html}.
\item \code{hpc}: logical values (\code{TRUE}/\code{FALSE}/\code{NA}) whether to send each target
to parallel workers.
Visit \url{https://books.ropensci.org/drake/hpc.html#selectivity}
to learn more.
\item \code{resources}: target-specific lists of resources for a computing cluster.
See
\url{https://books.ropensci.org/drake/hpc.html#advanced-options}
for details.
\item \code{caching}: overrides the \code{caching} argument of \code{\link[=make]{make()}} for each target
individually. Possible values:
\itemize{
\item "main": tell the main process to store the target in the cache.
\item "worker": tell the HPC worker to store the target in the cache.
\item NA: default to the \code{caching} argument of \code{\link[=make]{make()}}.
}
\item \code{elapsed} and \code{cpu}: number of seconds to wait for the target to build
before timing out (\code{elapsed} for elapsed time and \code{cpu} for CPU time).
\item \code{retries}: number of times to retry building a target
in the event of an error.
\item \code{seed}: an optional pseudo-random number generator (RNG)
seed for each target. \code{drake} usually comes up with its own
unique reproducible target-specific seeds using the global seed
(the \code{seed} argument to \code{\link[=make]{make()}} and \code{\link[=drake_config]{drake_config()}})
and the target names, but you can overwrite these automatic seeds.
\code{NA} entries default back to \code{drake}'s automatic seeds.
\item \code{max_expand}: for dynamic branching only. Same as the \code{max_expand}
argument of \code{\link[=make]{make()}}, but on a target-by-target basis.
Limits the number of sub-targets created for a given target.
}
}

\section{Keywords}{

\code{\link[=drake_plan]{drake_plan()}} understands special keyword functions for your commands.
With the exception of \code{\link[=target]{target()}}, each one is a proper function
with its own help file.
\itemize{
\item \code{\link[=target]{target()}}: give the target more than just a command.
Using \code{\link[=target]{target()}}, you can apply a transformation
(examples: \url{https://books.ropensci.org/drake/plans.html#large-plans}), # nolint
supply a trigger (\url{https://books.ropensci.org/drake/triggers.html}), # nolint
or set any number of custom columns.
\item \code{\link[=file_in]{file_in()}}: declare an input file dependency.
\item \code{\link[=file_out]{file_out()}}: declare an output file to be produced
when the target is built.
\item \code{\link[=knitr_in]{knitr_in()}}: declare a \code{knitr} file dependency such as an
R Markdown (\verb{*.Rmd}) or R LaTeX (\verb{*.Rnw}) file.
\item \code{\link[=ignore]{ignore()}}: force \code{drake} to entirely ignore a piece of code:
do not track it for changes and do not analyze it for dependencies.
\item \code{\link[=no_deps]{no_deps()}}: tell \code{drake} to not track the dependencies
of a piece of code. \code{drake} still tracks the code itself for changes.
\item \code{\link[=id_chr]{id_chr()}}: Get the name of the current target.
\item \code{\link[=drake_envir]{drake_envir()}}: get the environment where drake builds targets.
Intended for advanced custom memory management.
}
}

\section{Formats}{

Specialized target formats increase efficiency and flexibility.
Some allow you to save specialized objects like \code{keras} models,
while others increase the speed while conserving storage and memory.
You can declare target-specific formats in the plan
(e.g. \code{drake_plan(x = target(big_data_frame, format = "fst"))})
or supply a global default \code{format} for all targets in \code{make()}.
Either way, most formats have specialized installation requirements
(e.g. R packages) that are not installed with \code{drake} by default.
You will need to install them separately yourself.
Available formats:
\itemize{
\item \code{"file"}: Dynamic files. To use this format, simply create
local files and directories yourself and then return
a character vector of paths as the target's value.
Then, \code{drake} will watch for changes to those files in
subsequent calls to \code{make()}. This is a more flexible
alternative to \code{file_in()} and \code{file_out()}, and it is
compatible with dynamic branching.
See \url{https://github.com/ropensci/drake/pull/1178} for an example.
\item \code{"fst"}: save big data frames fast. Requires the \code{fst} package.
Note: this format strips non-data-frame attributes such as the
\item \code{"fst_tbl"}: Like \code{"fst"}, but for \code{tibble} objects.
Requires the \code{fst} and \code{tibble} packages.
Strips away non-data-frame non-tibble attributes.
\item \code{"fst_dt"}: Like \code{"fst"} format, but for \code{data.table} objects.
Requires the \code{fst} and \code{data.table} packages.
Strips away non-data-frame non-data-table attributes.
\item \code{"diskframe"}:
Stores \code{disk.frame} objects, which could potentially be
larger than memory. Requires the \code{fst} and \code{disk.frame} packages.
Coerces objects to \code{disk.frame}s.
Note: \code{disk.frame} objects get moved to the \code{drake} cache
(a subfolder of \verb{.drake/} for most workflows).
To ensure this data transfer is fast, it is best to
save your \code{disk.frame} objects to the same physical storage
drive as the \code{drake} cache,
\code{as.disk.frame(your_dataset, outdir = drake_tempfile())}.
\item \code{"keras"}: save Keras models as HDF5 files.
Requires the \code{keras} package.
\item \code{"qs"}: save any R object that can be properly serialized
with the \code{qs} package. Requires the \code{qs} package.
Uses \code{qsave()} and \code{qread()}.
Uses the default settings in \code{qs} version 0.20.2.
\item \code{"rds"}: save any R object that can be properly serialized.
Requires R version >= 3.5.0 due to ALTREP.
Note: the \code{"rds"} format uses gzip compression, which is slow.
\code{"qs"} is a superior format.
}
}

\examples{
# Use target() to create your own custom columns in a drake plan.
# See ?triggers for more on triggers.
drake_plan(
  website_data = target(
    download_data("www.your_url.com"),
    trigger = "always",
    custom_column = 5
  ),
  analysis = analyze(website_data)
)
models <- c("glm", "hierarchical")
plan <- drake_plan(
  data = target(
    get_data(x),
    transform = map(x = c("simulated", "survey"))
  ),
  analysis = target(
    analyze_data(data, model),
    transform = cross(data, model = !!models, .id = c(x, model))
  ),
  summary = target(
    summarize_analysis(analysis),
    transform = map(analysis, .id = c(x, model))
  ),
  results = target(
    bind_rows(summary),
    transform = combine(summary, .by = data)
  )
)
plan
if (requireNamespace("styler", quietly = TRUE)) {
  print(drake_plan_source(plan))
}
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
