% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpc.R
\name{drake_hpc_template_file}
\alias{drake_hpc_template_file}
\title{Write a template file for deploying
work to a cluster / job scheduler.
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}}
\usage{
drake_hpc_template_file(
  file = drake::drake_hpc_template_files(),
  to = getwd(),
  overwrite = FALSE
)
}
\arguments{
\item{file}{Name of the template file, including the "tmpl" extension.}

\item{to}{Character vector, where to write the file.}

\item{overwrite}{Logical, whether to overwrite an existing file of the
same name.}
}
\value{
\code{NULL} is returned,
but a batchtools template file is written.
}
\description{
See the example files from
\code{\link[=drake_examples]{drake_examples()}} and \code{\link[=drake_example]{drake_example()}}
for example usage.
}
\examples{
\dontrun{
plan <- drake_plan(x = rnorm(1e7), y = rnorm(1e7))
# List the available template files.
drake_hpc_template_files()
# Write a SLURM template file.
out <- file.path(tempdir(), "slurm_batchtools.tmpl")
drake_hpc_template_file("slurm_batchtools.tmpl", to = tempdir())
cat(readLines(out), sep = "\n")
# library(future.batchtools) # nolint
# future::plan(batchtools_slurm, template = out) # nolint
# make(plan, parallelism = "future", jobs = 2) # nolint
}
}
\seealso{
\code{\link[=drake_hpc_template_files]{drake_hpc_template_files()}},
\code{\link[=drake_examples]{drake_examples()}}, \code{\link[=drake_example]{drake_example()}},
\code{\link[=shell_file]{shell_file()}}
}
