% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_reduce.R
\name{gather_plan}
\alias{gather_plan}
\title{Write commands to combine several targets into one
or more overarching targets.}
\usage{
gather_plan(plan = NULL, target = "target", gather = "list",
  append = FALSE)
}
\arguments{
\item{plan}{workflow plan data frame of prespecified targets}

\item{target}{name of the new aggregated target}

\item{gather}{function used to gather the targets. Should be
one of \code{list(...)}, \code{c(...)}, \code{rbind(...)}, or similar.}

\item{append}{logical. If \code{TRUE}, the output will include the
original rows in the \code{plan} argument.
If \code{FALSE}, the output will only include the new
targets and commands.}
}
\value{
A workflow plan data frame that aggregates multiple
prespecified targets into one additional target downstream.
}
\description{
Creates a new workflow plan to aggregate
existing targets in the supplied plan.
}
\examples{
# Workflow plan for datasets:
datasets <- drake_plan(
  small = simulate(5),
  large = simulate(50)
)
# Create a new target that brings the datasets together.
gather_plan(datasets, target = "my_datasets", append = FALSE)
# This time, the new target just appends the rows of 'small' and 'large'
# into a single matrix or data frame.
gathered <- gather_plan(
  datasets,
  target = "aggregated_data",
  gather = "rbind",
  append = FALSE
)
gathered
# For the complete workflow plan, row bind the pieces together.
bind_plans(datasets, gathered)
# Alternatively, you can set `append = TRUE` to incorporate
# the new targets automatically.
gather_plan(
  datasets,
  target = "aggregated_data",
  gather = "rbind",
  append = TRUE
)
}
\seealso{
[drake_plan(), \code{\link[=map_plan]{map_plan()}}, \code{\link[=reduce_by]{reduce_by()}}, \code{\link[=gather_by]{gather_by()}}, \code{\link[=reduce_plan]{reduce_plan()}},
\code{\link[=evaluate_plan]{evaluate_plan()}}, \code{\link[=expand_plan]{expand_plan()}}
}
