% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{new_cache}
\alias{new_cache}
\title{Make a new \code{drake} cache.}
\usage{
new_cache(path = drake::default_cache_path(),
  verbose = drake::default_verbose(), type = NULL,
  short_hash_algo = drake::default_short_hash_algo(),
  long_hash_algo = drake::default_long_hash_algo(), ...,
  console_log_file = NULL)
}
\arguments{
\item{path}{file path to the cache if the cache
is a file system cache.}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\describe{
\item{0 or \code{FALSE}:}{print nothing.}
\item{1 or \code{TRUE}:}{print only targets to build.}
\item{2:}{in addition, print checks and cache info.}
\item{3:}{in addition, print any potentially missing items.}
\item{4:}{in addition, print imports. Full verbosity.}
}}

\item{type}{deprecated argument. Once stood for cache type.
Use \code{storr} to customize your caches instead.}

\item{short_hash_algo}{short hash algorithm for the cache.
See \code{\link[=default_short_hash_algo]{default_short_hash_algo()}} and
\code{\link[=make]{make()}}}

\item{long_hash_algo}{long hash algorithm for the cache.
See \code{\link[=default_long_hash_algo]{default_long_hash_algo()}} and
\code{\link[=make]{make()}}}

\item{...}{other arguments to the cache constructor}

\item{console_log_file}{character scalar or \code{NULL}.
If \code{NULL}, console output will be printed
to the R console using \code{message()}.
Otherwise, \code{console_log_file} should be the name of a flat file.
Console output will be appended to that file.}
}
\value{
A newly created drake cache as a storr object.
}
\description{
Uses the \code{\link[=storr_rds]{storr_rds()}} function
from the \code{storr} package.
}
\examples{
\dontrun{
test_with_dir("Quarantine new_cache() side effects.", {
clean(destroy = TRUE) # Should not be necessary.
unlink("not_hidden", recursive = TRUE) # Should not be necessary.
cache1 <- new_cache() # Creates a new hidden '.drake' folder.
cache2 <- new_cache(path = "not_hidden", short_hash_algo = "md5")
clean(destroy = TRUE, cache = cache2)
})
}
}
\seealso{
\code{\link[=default_short_hash_algo]{default_short_hash_algo()}},
\code{\link[=default_long_hash_algo]{default_long_hash_algo()}},
\code{\link[=make]{make()}}
}
