% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/static_drake_graph.R
\name{static_drake_graph}
\alias{static_drake_graph}
\title{Show static graph representation
of your drake project.}
\usage{
static_drake_graph(config = drake::read_drake_config(),
  build_times = "build", digits = 3, targets_only = FALSE,
  split_columns = NULL, main = NULL, from = NULL, mode = c("out", "in",
  "all"), order = NULL, subset = NULL, make_imports = TRUE,
  from_scratch = FALSE, full_legend = FALSE, group = NULL,
  clusters = NULL)
}
\arguments{
\item{config}{a \code{\link[=drake_config]{drake_config()}} configuration list.
You can get one as a return value from \code{\link[=make]{make()}} as well.}

\item{build_times}{character string or logical.
If character, the choices are
1. \code{"build"}: runtime of the command plus the time
it take to store the target or import.
2. \code{"command"}: just the runtime of the command.
3. \code{"none"}: no build times.
If logical, \code{build_times} selects whether to show the
times from `build_times(..., type = "build")`` or use
no build times at all. See \code{\link[=build_times]{build_times()}} for details.}

\item{digits}{number of digits for rounding the build times}

\item{targets_only}{logical,
whether to skip the imports and only include the
targets in the workflow plan.}

\item{split_columns}{logical, deprecated.}

\item{main}{character string, title of the graph}

\item{from}{Optional collection of target/import names.
If \code{from} is nonempty,
the graph will restrict itself to
a neighborhood of \code{from}.
Control the neighborhood with
\code{mode} and \code{order}.}

\item{mode}{Which direction to branch out in the graph
to create a neighborhood around \code{from}.
Use \code{"in"} to go upstream,
\code{"out"} to go downstream,
and \code{"all"} to go both ways and disregard
edge direction altogether.}

\item{order}{How far to branch out to create
a neighborhood around \code{from} (measured
in the number of nodes). Defaults to
as far as possible.}

\item{subset}{Optional character vector of of target/import names.
Subset of nodes to display in the graph.
Applied after \code{from}, \code{mode}, and \code{order}.
Be advised: edges are only kept for adjacent nodes in \code{subset}.
If you do not select all the intermediate nodes,
edges will drop from the graph.}

\item{make_imports}{logical, whether to make the imports first.
Set to \code{FALSE} to increase speed and risk using obsolete information.}

\item{from_scratch}{logical, whether to assume all the targets
will be made from scratch on the next \code{\link[=make]{make()}}.
Makes all targets outdated, but keeps information about
build progress in previous \code{\link[=make]{make()}}s.}

\item{full_legend}{logical. If \code{TRUE}, all the node types
are printed in the legend. If \code{FALSE}, only the
node types used are printed in the legend.}

\item{group}{optional character scalar, name of the column used to
group nodes into columns. All the columns names of your \code{config$plan}
are choices. The other choices (such as \code{"status"}) are column names
in the \code{nodes} . To group nodes into clusters in the graph,
you must also supply the \code{clusters} argument.}

\item{clusters}{optional character vector of values to cluster on.
These values must be elements of the column of the \code{nodes} data frame
that you specify in the \code{group} argument to \code{drake_graph_info()}.}
}
\value{
A \code{ggplot2} object, which you can modify with more layers,
show with \code{plot()}, or save as a file with \code{ggsave()}.
}
\description{
This function requries packages \code{ggplot2} and \code{ggraph}.
Install them with \code{install.packages(c("ggplot2", "ggraph"))}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
config <- drake_config(my_plan)
# Plot the network graph representation of the workflow.
static_drake_graph(config) # Save to a file with `ggplot2::ggsave()`.
})
}
}
\seealso{
\code{\link[=vis_drake_graph]{vis_drake_graph()}}, \code{\link[=sankey_drake_graph]{sankey_drake_graph()}},
\code{\link[=render_static_drake_graph]{render_static_drake_graph()}}
}
