% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_log.R
\name{drake_cache_log_file}
\alias{drake_cache_log_file}
\title{Generate a flat text log file
to represent the state of the cache.}
\usage{
drake_cache_log_file(file = "drake_cache.log", path = getwd(),
  search = TRUE, cache = drake::get_cache(path = path, search = search,
  verbose = verbose), verbose = drake::default_verbose(), jobs = 1,
  targets_only = FALSE)
}
\arguments{
\item{file}{character scalar, name of the flat text log file.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\describe{
\item{0 or \code{FALSE}:}{print nothing.}
\item{1 or \code{TRUE}:}{print only targets to build.}
\item{2:}{in addition, print checks and cache info.}
\item{3:}{in addition, print any potentially missing items.}
\item{4:}{in addition, print imports. Full verbosity.}
}}

\item{jobs}{number of jobs/workers for parallel processing}

\item{targets_only}{logical, whether to output information
only on the targets in your workflow plan data frame.
If \code{targets_only} is \code{FALSE}, the output will
include the hashes of both targets and imports.}
}
\value{
There is no return value, but a log file is generated.
}
\description{
This functionality is like
\code{\link{make}(..., cache_log_file = TRUE)},
but separated and more customizable.
The \code{drake_cache_log_file()} function writes a flat text file
to represents the state of all the targets and imports in the cache.
If you call it after each \code{\link[=make]{make()}}
and put the log file under version control,
you can track the changes to your results over time.
This way, your data is versioned alongside your code
in a easy-to-view format. Hopefully, this functionality
is a step toward better data versioning tools.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
# Load drake's canonical example.
load_basic_example() # Get the code with drake_example()
# Run the project and save a flat text log file.
make(my_plan)
drake_cache_log_file() # writes drake_cache.log
# The above 2 lines are equivalent to make(my_plan, cache_log_file = TRUE) # nolint
# At this point, put drake_cache.log under version control
# (e.g. with 'git add drake_cache.log') alongside your code.
# Now, every time you run your project, your commit history
# of hash_lot.txt is a changelog of the project's results.
# It shows which targets and imports changed on every commit.
# It is extremely difficult to track your results this way
# by putting the raw '.drake/' cache itself under version control.
})
}
}
\seealso{
\code{\link[=drake_cache_log]{drake_cache_log()}},
\code{\link[=make]{make()}},
\code{\link[=get_cache]{get_cache()}},
\code{\link[=default_long_hash_algo]{default_long_hash_algo()}},
\code{\link[=short_hash]{short_hash()}},
\code{\link[=long_hash]{long_hash()}}
}
