% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_imports}
\alias{make_imports}
\title{Just make the imports.}
\usage{
make_imports(config)
}
\arguments{
\item{config}{a configuration list returned by \code{\link{config}()}}
}
\value{
The master internal configuration list
used by \code{\link{make}()}.
}
\description{
\code{\link{make}()} is the central, most important function
of the drake package. \code{\link{make}()} runs all the steps of your
workflow in the correct order, skipping any work
that is already up to date. During \code{\link{make}()},
there are two kinds of processing steps: "imports",
which are pre-existing functions and input data files
that are loaded or checked, and targets, which are
serious reproducibly-tracked data analysis steps
that have commands in your workflow plan data frame.
The \code{\link{make_targets}()} function just makes the targets
(skipping any targets that are already up to date)
and \code{\link{make_imports}()} just makes the imports.
Most users should just use \code{\link{make}()}
instead of either \code{\link{make_imports}()} or
\code{\link{make_targets}()}.
See \url{https://ropensci.github.io/drake/}
for the full documentation of drake,
including multiple in-depth tutorials.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
# Generate the master internal configuration list.
con <- drake_config(my_plan)
# Just cache the imports, do not build any targets.
make_imports(config = con)
# Just make the targets
make_targets(config = con)
})
}
}
\seealso{
\code{\link{make}}, \code{\link{config}},
\code{\link{make_targets}}
}
