% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{failed}
\alias{failed}
\title{List the targets that failed in the last call
to \code{\link{make}()}.}
\usage{
failed(path = getwd(), search = TRUE, cache = drake::get_cache(path =
  path, search = search, verbose = verbose), verbose = TRUE)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{optional drake cache. See code{\link{new_cache}()}.
If \code{cache} is supplied,
the \code{path} and \code{search} arguments are ignored.}

\item{verbose}{whether to print console messages}
}
\value{
A character vector of target names.
}
\description{
Together, functions \code{failed} and
\code{\link{diagnose}()} should eliminate the strict need
for ordinary error messages printed to the console.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
make(my_plan) # Run the project, build the targets.
failed() # Should show that no targets failed.
# Build a workflow plan doomed to fail:
bad_plan <- drake_plan(x = function_doesnt_exist())
try(make(bad_plan), silent = TRUE) # error
failed() # "x"
diagnose(x) # Retrieve the cached error log of x.
})
}
}
\seealso{
\code{\link{diagnose}}, \code{\link{session}},
\code{\link{built}}, \code{\link{imported}},
\code{\link{readd}}, \code{\link{drake_plan}}, \code{\link{make}}
}
