% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{drake_build}
\alias{drake_build}
\title{Build/process a single target or import.}
\usage{
drake_build(target, config, meta = NULL)
}
\arguments{
\item{target}{name of the target}

\item{config}{internal configuration list}

\item{meta}{list of metadata that tell which
targets are up to date (from \code{drake_meta()}).}
}
\value{
The value of the target right after it is built.
}
\description{
For internal use only.
the only reason this function is exported
is to set up parallel socket (PSOCK) clusters
without much of a fuss.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
# This example is not really a user-side demonstration.
# It just walks through a dive into the internals.
# Populate your workspace and write 'report.Rmd'.
load_basic_example() # Get the code with drake_example("basic").
# Create the master internal configuration list.
config <- drake_config(my_plan)
# Optionally, compute metadata on 'small',
# including a hash/fingerprint
# of the dependencies. If meta is not supplied,
# drake_build() computes it automatically.
meta <- drake_meta(target = "small", config = config)
# Should not yet include 'small'.
cached()
# Build 'small'.
# Equivalent to just drake_build(target = "small", config = config).
drake_build(target = "small", config = config, meta = meta)
# Should now include 'small'
cached()
readd(small)
})
}
}
\keyword{internal}
