% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitr.R
\name{knitr_deps}
\alias{knitr_deps}
\title{Function knitr_deps}
\usage{
knitr_deps(target)
}
\arguments{
\item{target}{file path to the file or name of the file target,
source text of the document.}
}
\description{
Find the dependencies of a dynamic report. To
enable drake to watch for these dependencies, your workplan
plan command to compile this report must make direct use of
\code{knitr::knit()}.
That is, it must look something like \code{knit('your_report.Rmd')}
in your workflow plan data frame.
}
\details{
Drake looks for dependencies in the document by
analyzing evaluated code chunks for other targets/imports
mentioned in \code{\link{loadd}()} and \code{\link{readd}()}.
}
\examples{
\dontrun{
load_basic_example()
knitr_deps("'report.Rmd'") # Files must be single-quoted
knitr_deps("report.Rmd")
make(my_plan)
knitr_deps("'report.md'") # Work on the Rmd source, not the output.
}
}
\seealso{
\code{\link{knitr_deps}},
\code{\link{deps}},
\code{\link{make}}, \code{\link{load_basic_example}}
}
