% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/manip.r
\name{select}
\alias{rename}
\alias{rename_}
\alias{select}
\alias{select_}
\title{Select/rename variables by name.}
\usage{
select(.data, ...)

select_(.data, ..., .dots)

rename(.data, ...)

rename_(.data, ..., .dots)
}
\arguments{
\item{.data}{A tbl. All main verbs are S3 generics and provide methods
for \code{\link{tbl_df}}, \code{\link{tbl_dt}} and \code{\link{tbl_sql}}.}

\item{...}{Comma separated list of unquoted expressions. You can treat
variable names like they are positions. Use positive values to select
variables; use negative values to drop variables.}

\item{.dots}{Use \code{select_()} to do standard evaluation. See
\code{vignette("nse")} for details}
}
\value{
An object of the same class as \code{.data}.

  Data frame row names are silently dropped. To preserve, convert to an
  explicit variable.
}
\description{
\code{select()} keeps only the variables you mention; \code{rename()}
keeps all variables.
}
\section{Special functions}{

As well as using existing functions like \code{:} and \code{c}, there are
a number of special functions that only work inside \code{select}

\itemize{
 \item \code{starts_with(x, ignore.case = TRUE)}:
   names starts with \code{x}
 \item \code{ends_with(x, ignore.case = TRUE)}:
   names ends in \code{x}
 \item \code{contains(x, ignore.case = TRUE)}:
   selects all variables whose name contains \code{x}
 \item \code{matches(x, ignore.case = TRUE)}:
   selects all variables whose name matches the regular expression \code{x}
 \item \code{num_range("x", 1:5, width = 2)}:
   selects all variables (numerically) from x01 to x05.
 \item \code{one_of("x", "y", "z")}:
   selects variables provided in a character vector.
 \item \code{everything()}:
   selects all variables.
}

To drop variables, use \code{-}. You can rename variables with
named arguments.
}
\examples{
iris <- tbl_df(iris) # so it prints a little nicer
select(iris, starts_with("Petal"))
select(iris, ends_with("Width"))
select(iris, contains("etal"))
select(iris, matches(".t."))
select(iris, Petal.Length, Petal.Width)
vars <- c("Petal.Length", "Petal.Width")
select(iris, one_of(vars))

df <- as.data.frame(matrix(runif(100), nrow = 10))
df <- tbl_df(df[c(3, 4, 7, 1, 9, 8, 5, 2, 6, 10)])
select(df, V4:V6)
select(df, num_range("V", 4:6))

# Drop variables
select(iris, -starts_with("Petal"))
select(iris, -ends_with("Width"))
select(iris, -contains("etal"))
select(iris, -matches(".t."))
select(iris, -Petal.Length, -Petal.Width)

# Rename variables:
# * select() keeps only the variables you specify
select(iris, petal_length = Petal.Length)
# Renaming multiple variables uses a prefix:
select(iris, petal = starts_with("Petal"))

# Reorder variables: keep the variable "Species" in the front
select(iris, Species, everything())

# * rename() keeps all variables
rename(iris, petal_length = Petal.Length)

# Programming with select ---------------------------------------------------
select_(iris, ~Petal.Length)
select_(iris, "Petal.Length")
select_(iris, lazyeval::interp(~matches(x), x = ".t."))
select_(iris, quote(-Petal.Length), quote(-Petal.Width))
select_(iris, .dots = list(quote(-Petal.Length), quote(-Petal.Width)))
}
\seealso{
Other single.table.verbs: \code{\link{arrange}},
  \code{\link{arrange_}}; \code{\link{filter}},
  \code{\link{filter_}}; \code{\link{mutate}},
  \code{\link{mutate_}}, \code{\link{transmute}},
  \code{\link{transmute_}}; \code{\link{slice}},
  \code{\link{slice_}}; \code{\link{summarise}},
  \code{\link{summarise_}}, \code{\link{summarize}},
  \code{\link{summarize_}}
}

