% Generated by roxygen2 (4.0.1): do not edit by hand
\name{groups}
\alias{groups}
\alias{regroup}
\alias{ungroup}
\title{Get/set the grouping variables for tbl.}
\usage{
groups(x)

regroup(x, value)

ungroup(x)
}
\arguments{
\item{x}{data \code{\link{tbl}}}

\item{value}{a list of symbols}
}
\description{
These functions do not perform non-standard evaluation, and so are useful
when programming against \code{tbl} objects. \code{ungroup} is a convenient
inline way of removing existing grouping.
}
\examples{
grouped <- group_by(mtcars, cyl)
groups(grouped)
grouped <- regroup(grouped, list(quote(vs)))
groups(grouped)
groups(ungroup(grouped))
}
\seealso{
\code{\link{group_by}} for a version that does non-standard
  evaluation to save typing
}

