% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downscaleautonet.R
\name{ResautoDownscale}
\alias{ResautoDownscale}
\title{ResautoDownscale}
\usage{
ResautoDownscale(r2, fpredict0, c.grid, ss = 0.2, nepoch = 30,
  cores = 1, thresh = 0.01, ntime = 5)
}
\arguments{
\item{r2}{Stack for the covariates for downscaling}

\item{fpredict0}{ Target fine-resolution image to be downscaled, you can just provide a NA image data (this function can fill this NA) or an initial predictions obtained by other methods.}

\item{c.grid}{Coarsely resolved grid}

\item{ss}{Sampling propotion for independent test}

\item{nepoch}{Numder of epoch for residual network training (default: 30)}

\item{cores}{Number of CPU cores used for computing (default: 1)}

\item{thresh}{Stopping creation shreshold (default: 0.01)}

\item{ntime}{Maximum number of iterations (default: 5)}
}
\value{
List(performance metrics such as R2, RMSE, and downscaled images)
}
\author{
Lianfa Li \email{lspatial@gmail.com}
}
\description{
This function is the iterative implementation of downscaling with autoencoder based residual network.
}
\seealso{
 \code{\link{AutoEncoderModel}} for the residual network function used in downscaling.
}
\examples{
  #Load the high-resolution raster of a covariate, 
  # elevation to be used for downscaling  
  eleFile=file.path(system.file(package = "downscaledl"), "extdata", "sample_ele.tif")
  ele=raster::raster(eleFile)

  #Load the coarse-resolution raster of the target variable to be downscaled  
  coarseFile=file.path(system.file(package = "downscaledl"), "extdata", "sample_coarse_res.tif")
  coarseRst=raster::raster(coarseFile)

  #Extract x and y to be used as two predictors in downscaling 
  xRast=ele
  yRast=ele
  pos=raster::rasterToPoints(ele,spatial=TRUE)
  cell=raster::cellFromXY(xRast,pos)
  xyc=sp::coordinates(pos)
  xRast[cell]=xyc[,"x"]
  yRast[cell]=xyc[,"y"]

  #Merge the covariates 
  covStk=raster::stack(xRast,yRast,ele)
  names(covStk)=c("x","y","ele")

  #Use the fine-resolution covariate (elevation) as the target image 
  fineTarget=ele
\donttest{
  #Set the paramneters and start to downscale ...  
  ares=ResautoDownscale(covStk,fineTarget,coarseRst,ss= 0.2, cores= 5, thresh = 0.01,ntime=3)
  
  #Show the iteration results 
  message(paste(capture.output(ares$diogRMSE), collapse = "\n",sep=""))
  
  #Show the optimal results in the final predictions 
  message(paste("test R2:",round(ares$r2,2),",test RMSE:",round(ares$rmse,4),sep="")) 
  
  #Obtain the downscaled
  downscaled_img=ares$raster
  
  #Save the current par setting 
  curpar = par(no.readonly = TRUE)

  #Set the new par setting 
  par(mfrow=c(1,2),mar=c(1,1,1,1))
  
  #Show the final predictions of fine resolution and 
  # original coarse-resolution image for a comparison 
  raster::plot(coarseRst)
  raster::plot(downscaled_img)
  
  #Restore the previous par setting 
  par(curpar) 
}
}
