% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_dir}
\alias{download_dir}
\title{Download a directory}
\usage{
download_dir(
  path,
  output_name,
  button_label = "Download data",
  button_type = c("default", "primary", "success", "info", "warning", "danger"),
  has_icon = TRUE,
  icon = "fa fa-save",
  self_contained = FALSE,
  ...
)
}
\arguments{
\item{path}{Path to directory.}

\item{output_name}{Name of of the output file.}

\item{button_label}{Character (HTML), button label}

\item{button_type}{Character, one of the standard Bootstrap types}

\item{has_icon}{Specify whether to include fontawesome icons in the button label}

\item{icon}{Fontawesome tag e.g.: "fa fa-save"}

\item{self_contained}{A boolean to specify whether your HTML output is self-contained. Default to \code{FALSE}.}

\item{...}{attributes (named arguments) and children (unnamed arguments)
of the button, passed to \code{htmltools::tag()}.}
}
\value{
\code{htmltools::\link[htmltools]{tag}}, \code{<button>}
}
\description{
The path is converted into a \code{.zip} file.
}
\examples{
\dontrun{
## Directory path as an example
download_dir(
path = system.file("assets", package = "downloadthis"),
output_name = "example dir",
button_label = "Download directory",
button_type = "success",
has_icon = TRUE,
icon = "fa fa-save",
self_contained = FALSE
)
}
}
