% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/relabel_y_axis.R
\name{relabel_y_axis}
\alias{relabel_y_axis}
\title{Relabel the Y-Axis of a Dot-Whisker Plot}
\usage{
relabel_y_axis(x)
}
\arguments{
\item{x}{A vector of labels for predictors, listed from top to bottom}
}
\description{
\code{relabel_y_axis} is a convenience function for relabeling the predictors on the y-axis of a dot-whisker plot created by \code{\link[dotwhisker]{dwplot}}
}
\examples{
data(mtcars)
m1 <- lm(mpg ~ wt + cyl + disp, data = mtcars)
dwplot(m1) + relabel_y_axis(c("Intercept", "Weight", "Cylinders", "Displacement"))
}
\seealso{
\code{\link[dotwhisker]{relabel_predictors}} to relabel the predictors in a tidy data.frame before using \code{\link[dotwhisker]{dwplot}}
}

