% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dot.R
\name{zsc}
\alias{zsc}
\title{Calculate Z-scores from P-values and estimated effects}
\usage{
zsc(P, BETA)
}
\arguments{
\item{P}{vector of P-values.}

\item{BETA}{vector of effect directions or beta coefficients.}
}
\value{
A vector of Z-scores.
}
\description{
\code{\link[=zsc]{zsc()}} recovers Z-scores from  P-values and corresponding effect directions
(or beta coefficients) reported by a genetic association analysis.
}
\details{
For any  genetic variant,  its two-sided  P-value (\eqn{p})  and the  sign of
estimated effect (\eqn{\beta}) is used to recover the Z-score (\eqn{z}), that
is, \eqn{z = sign(\beta) \Phi^{-1}(p/2)}.
}
\examples{
## result of per-variant analysis (P-values and estimated effects)
res <- readRDS(system.file("extdata", 'rs208294_res.rds', package="dotgen"))

## recover Z-score statistics
stt <- with(res, zsc(P, BETA))

## checking
stopifnot(all.equal(pnorm(abs(stt), lower.tail = FALSE) * 2, res$P))

}
\seealso{
\code{\link[=dot]{dot()}}
}
