% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dosresmeta.R
\name{dosresmeta.control}
\alias{dosresmeta.control}
\title{Ancillary Parameters for Controlling the Fit in dosresmeta Models}
\usage{
dosresmeta.control(optim = list(), showiter = FALSE, maxiter = 1000,
  initPsi = NULL, igls.iter = 10, gr = FALSE,
  reltol = sqrt(.Machine$double.eps),
  set.negeigen = sqrt(.Machine$double.eps))
}
\arguments{
\item{optim}{list of parameters passed to the control argument of the function optim, which performs the quasi-Newton optimization in likelihood-based 
random-effects models. See \code{\link{optim}}.}

\item{showiter}{logical. If \code{TRUE}, the progress of iterative optimization is shown.}

\item{maxiter}{positive interger value. Maximum number of iterations in methods involving optimization procedures.}

\item{initPsi}{either a matrix or a vector of its lower triangular elements (with diagonal, taken by column) from which starting 
values of the parameters of the between-study (co)variance matrix are derived, used in the optimization procedure for likelihood-based random-effects models. 
If \code{NULL} (the default, and recommended), the starting value is created internally through an iterative generalized least square algorithm.}

\item{igls.iter}{number of iteration of the iterative generalized least square algorithm to be run in the hybrid optimization procedure 
of linkelihood-based models to provide the starting value.}

\item{gr}{indicates if the gradient of the (re)ml likelihood should be provided. FALSE by default.}

\item{reltol}{relative convergence tolerance in methods involving optimization procedures. The algorithm stops if it is unable to 
reduce the value by a factor of \eqn{reltol * (abs(val) + reltol)} at a step.}

\item{set.negeigen}{positive value. Value to which negative eigenvalues are to be set in estimators where such method is used
to force positive semi-definiteness of the estimated between-study (co)variance matrix.}
}
\value{
A list with components named as the arguments.
}
\description{
This internal function sets the parameter options used for fitting dose-response meta-analytical models, commonly to pre-specified default values. 
It is usually internally called by \code{\link{dosresmeta.fit}}.
}
\examples{
## Loading data
data("alcohol_cvd")

## print the iterations (see ?optim) and change the default for starting values
dosresmeta(formula = logrr ~ dose, type = type, id = id, se = se, 
           cases = cases, n = n, data = alcohol_cvd, proc = "1stage",
           control = list(showiter = TRUE, igls.iter = 20))
           
}
\references{
Gasparrini, A., Armstrong, B.,  Kenward, M. G. (2012). Multivariate meta-analysis for non-linear and other multi-parameter associations. 
Statistics in Medicine, 31(29), 3821-3839.
}
\seealso{
\code{\link{dosresmeta}}, \code{\link{dosresmeta-package}}, \code{\link{mvmeta.control}}
}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
