% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.dosresmeta}
\alias{predict.dosresmeta}
\title{Predicted Values from dosresmeta Models}
\usage{
\method{predict}{dosresmeta}(object, newdata, xref, expo = FALSE, xref_vec,
  ci.incl = TRUE, se.incl = FALSE, xref_pos = 1, delta, order = FALSE,
  ci.level = 0.95, ...)
}
\arguments{
\item{object}{an object of class \code{dosreseta}.}

\item{newdata}{an optional data frame or matrix in which to look for variables values with which to predict from dose-response models.}

\item{xref}{an optional scalar to indicate which levels should serve as referent for the predicted relative risks. See details.}

\item{expo}{logical switch indicating if the prediction should be on the exponential scale.}

\item{xref_vec}{an optional numeric to indicate the referent (vector) for the predicted relative risks. See details.}

\item{ci.incl}{logical switch indicating if confidence intervals need to be included.}

\item{se.incl}{logical switch indicating if standard errors need to be included.}

\item{xref_pos}{an optional scalar to indicate the position of the referent for the predicted relative risks. See details.}

\item{delta}{an optional scalar to specify to predict the linear trend related to that increase.}

\item{order}{logical to indicate if the predictions need to be sorted by exposure levels.}

\item{ci.level}{a numerical value between 0 and 1, specifying the confidence level for the computation of confidence intervals.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
The results are returned structured in a data frame.
}
\description{
This method function computes predictions from fitted dose-response models 
represented in objects of class "\code{dosresmeta}", optionally for a new set of exposure levels. 
Predictions are optionally accompanied by confidence intervals and/or standard errors for the predictions.
}
\details{
The method function \code{predict} produces predicted values from \code{dosresmeta} objects. When more than one study is included in the analysis,
estimated predictions are only based on the fixed part of the model.

If \code{newdata} is omitted, the predictions are based on the data used for the fit. If \code{xref} is provided, it must be equal to one of the modeled values. 
If not
provided, the minimum modeled referent value will be used as referent for the predicted relative risks

If \code{newdata} is specified, it should include all the variables used to model the dose-response relation. Again, if specified, \code{xref} must be equal to one
of the value in the newdata. If omitted, the minimum value for the newdara will be used as referent.

Only for the linear trend it is possible to specify the predicted increase of risk correspongind to an increase equal to \code{delta} argument.

By default (\code{order = TRUE}), the predictions are sorted by exposure levels to facilitate understanding and possible graphical
presentation of the results.
}
\examples{
## Load data and run the linear and quadratic models
data("alcohol_cvd")
lin <- dosresmeta(formula = logrr ~ dose, type = type, id = id,
                  se = se, cases = cases, n = n, data = alcohol_cvd) 
quadr <- dosresmeta(formula = logrr ~ dose + I(dose^2), type = type, id = id,
                    se = se, cases = cases, n = n, data = alcohol_cvd) 

## Predicted linear trend (on RR scale)
#predict(lin, delta = 12, expo = TRUE)

## Predicted modeled data from quadratic model (on RR scale)
#predict(quadr, expo = TRUE)

## Plot predicted dose-response relation
#with(predict(quadr, order = TRUE, expo = TRUE), {
#   plot(dose, pred, log = "y", type = "l",
#        xlim = c(0, 45), ylim = c(.4, 2))
#   lines(dose,  ci.lb, lty = 2)
#   lines(dose, ci.ub, lty = 2)
#   rug(dose, quiet = TRUE)
#})

## Prediction for new values from quadratic model (on RR scale)
newdata <- data.frame(dose = seq(0, 50, 5))
#predict(quadr, newdata, expo = TRUE)

## Loading data
data("ari")

mod <- dosresmeta(y ~ dose + I(dose^2), id = id, sd = sd,
 n = n, data = ari, covariance = "smd")

## Smoothed plot
newdata <- data.frame(dose = seq(0, 30, 1))
#with(predict(mod, newdata), {
#   plot(dose, pred, type = "l", ylim = c(0, .6))
#   lines(dose,  ci.lb, lty = 2)
#   lines(dose, ci.ub, lty = 2)
#   rug(dose, quiet = TRUE)
#})

}
\seealso{
\code{\link{dosresmeta}}, \code{\link{predict}}
}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
