% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{class}
\name{dosresmetaObject}
\alias{dosresmetaObject}
\title{dosresmeta Object}
\value{
Objects of class "\code{dosresmeta}" are lists with defined
components. Dimensions of such components differs according to the choosen
procedure. For the one-stage analysis the dimensions refer to a one
dimensional outcome, \eqn{p} predictors and \eqn{m} studies used for fitting
the model. For the two-stage analysis the dimensions refer to \eqn{p}
outcome parameters, no predictor (only the intercept) and \eqn{m} studies.
The following components needs to be included in a legitimate mvmeta object: 
\tabular{ll}{ 
\code{coefficients} \tab a \eqn{p}-dimensional vector of the fixed-effects coefficients. \cr 
\code{vcov} \tab estimated \eqn{p \times p}{p x p} (co)variance matrix of the fixed-effects coefficients. \cr
\code{Psi} \tab for random-effects models, the estimated \eqn{p \times p}{p x p} between-study (co)variance matrix. \cr
\code{residuals} \tab a vector of residuals, that is observed minus fitted values. \cr
\code{fitted.values} \tab a vector of of fitted mean values. \cr
\code{df.residual} \tab the residual degrees of freedom. \cr
\code{rank} \tab the numeric rank of the fitted model. \cr
\code{logLik} \tab the (restricted) log-likelihood of the fitted model. \cr
\code{converged,niter} \tab for models with iterative estimation methods, logical scalar indicating if the algorithm eventually 
converged, and number of iterations. \cr
\code{control} \tab a list with the values of the control arguments used, as returned by \code{\link{dosresmeta.control}}. \cr
\code{method} \tab the estimation method. \cr
\code{dim} \tab list with the following scalar components: \eqn{m} (number of studies included in estimation, \eqn{k} (number of outcome parameters), 
\eqn{p} (number of predictors). \cr
\code{df} \tab list with the following scalar components: nall (number of observations used for estimation, excluding missing values), 
nobs (equal to nall, minus the number of fixed-effects coefficients in REML models), fixed (number of estimated fixed-effects coefficients), 
random (number of estimated (co)variance terms). \cr
\code{lab} \tab list with the following label vectors: \eqn{p} for the p predictors (including intercept). \cr
\code{model} \tab the model frame used for fitting. \cr
\code{call} \tab the function call. \cr
\code{formula} \tab the model supplied. \cr
\code{terms} \tab the \code{\link{terms}} object representing the fitted model. \cr
\code{proc} \tab the estimation procedure. \cr
\code{center} \tab if the desing matrix had been centered. \cr
\code{covariance} \tab how the (co)variance had been appproximated. \cr
\code{Slist} \tab list of approximated (co)variance matrices. \cr
\code{id} \tab identification vector of the studies. \cr
\code{v} \tab variances of the outcome values
}
}
\description{
An object returned by \code{dosresmeta} function, inheriting
  from class "\code{dosresmeta}", and representing a fitted dose-response
  (meta-analytical) model.
}
\section{Methods}{


A number of methods functions are available for \code{\link{dosresmeta}} objects, most of them common to other regression functions. 
Specifically-written method functions are defined for predict (standard predictions). The qtest method performs the Cochran Q test for heterogeneity only for a two-stage analysis. 
Other methods have been produced for summary, logLik, coef, and vcov. Printing functions for the objects of classes defined above are also provided.
All the methods above are visible (exported from the namespace) and documented. In additions, several default method functions for regression are also 
applicable to objects of class "mvmeta", such as fitted, residuals, AIC, BIC and update, among others.
}

\seealso{
\code{\link{dosresmeta}}, \code{\link{dosresmeta-package}}, \code{\link{mvmetaObject}}
}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
