% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngramTokens.R
\name{ngramTokens}
\alias{ngramTokens}
\title{Ngram Tokenizer}
\usage{
ngramTokens(
  texts,
  wstem = "all",
  ngrams = 1,
  language = "english",
  punct = TRUE,
  stop.words = TRUE,
  overlap = 1,
  sparse = 0.995,
  verbose = FALSE,
  vocabmatch = NULL,
  num.mc.cores = 1
)
}
\arguments{
\item{texts}{character vector of texts.}

\item{wstem}{character Which words should be stemmed? Defaults to "all".}

\item{ngrams}{numeric Vector of ngram lengths to be included. Default is 1 (i.e. unigrams only).}

\item{language}{Language for stemming. Default is "english"}

\item{punct}{logical Should punctuation be kept as tokens? Default is TRUE}

\item{stop.words}{logical Should stop words be kept? Default is TRUE}

\item{overlap}{numeric Threshold (as cosine distance) for including ngrams that constitute other included phrases. Default is 1 (i.e. all ngrams included).}

\item{sparse}{maximum feature sparsity for inclusion (1 = include all features)}

\item{verbose}{logical Should the package report token counts after each ngram level? Useful for long-running code. Default is FALSE.}

\item{vocabmatch}{matrix Should the new token count matrix will be coerced to include the same tokens as a previous count matrix? Default is NULL (i.e. no token match).}
}
\value{
a matrix of feature counts
}
\description{
Tally bag-of-words ngram features
}
\keyword{internal}
