% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_ops.R
\name{formula_ops}
\alias{formula_ops}
\alias{formula_add}
\alias{formula_poly}
\alias{formula_nth}
\alias{formula_to_interaction_matrix}
\alias{formula_chr_to_form}
\alias{to_str}
\alias{terms_labels}
\alias{simplify_rhs}
\alias{simplify_rhs.formula}
\alias{simplify_rhs.character}
\alias{as_rhs_frm}
\alias{as_lhs_frm}
\alias{as_rhs_chr}
\alias{as_lhs_chr}
\alias{unique_formula}
\title{Formula operations and coercion.}
\usage{
formula_add(frm1, frm2)

formula_poly(chr1, n, noint = FALSE, y = NULL)

formula_nth(frm1, n)

formula_to_interaction_matrix(frm1)

formula_chr_to_form(rhs, lhs = character(0))

to_str(chr1, collapse = "+")

terms_labels(frm1)

simplify_rhs(object)

\method{simplify_rhs}{formula}(object)

\method{simplify_rhs}{character}(object)

as_rhs_frm(object)

as_lhs_frm(object)

as_rhs_chr(object, string = FALSE)

as_lhs_chr(object, string = FALSE)

unique_formula(list_of_formulas)
}
\arguments{
\item{frm1, frm2}{Formulas to be coerced to character vectors.}

\item{chr1}{Character vector to be coerced to formulas.}

\item{n}{Positive integer.}

\item{noint}{Boolean.}

\item{y}{Response}

\item{rhs, lhs}{right-hand-side and left-hand-side for formula (as characters)}

\item{collapse}{Character to use as separator.}

\item{object}{Character vector or formula.}

\item{string}{Boolean.}

\item{list_of_formulas}{list of formulas}
}
\description{
Formula operations and coercion as a supplement to \code{update.formula()}
}
\examples{

formula_poly("z", 2)
formula_poly("z", 2, noint=TRUE)

as_rhs_chr(c("a", "b", "z"))
as_rhs_chr(c("a*b", "z"))

as_rhs_chr(y~a+b+z)
as_rhs_chr(y~a+b+z, string=TRUE)
as_rhs_chr(y~a+b+z)
as_rhs_chr(y~a*b+z)
as_rhs_chr(y~a*b+z, string=TRUE)

as_lhs_chr(y~a*b+z)
as_lhs_chr(log(y)~a*b+z)      ## Not what one might expect
as_lhs_chr(cbind(y, u)~a*b+z) ## Not what one might expect

formula_chr_to_form(c("a*b", "z"))
formula_chr_to_form(c("a*b", "z"), "y")
formula_chr_to_form(c("a*b", "z"), "log(y)")

formula_add(y~a*b+z, ~-1)
formula_add(y~a*b+z, ~a:b)

}
