% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dSVDsignif.r
\name{dSVDsignif}
\alias{dSVDsignif}
\title{Function to obtain SVD-based gene significance from the input gene-sample matrix}
\usage{
dSVDsignif(data, num.eigen = NULL, pval.eigen = 0.01, signif = c("fdr",
"pval"), orient.permutation = c("row", "column", "both"),
num.permutation = 100, fdr.procedure = c("stepup", "stepdown"),
verbose = T)
}
\arguments{
\item{data}{an input gene-sample data matrix used for singular value
decomposition}

\item{num.eigen}{an integer specifying the number of eigens in
consideration. If NULL, this number will be automatically decided on
based on the observed relative eigenexpression against randomised
relative eigenexpression calculated from a list (here 100) of
permutated input matrix}

\item{pval.eigen}{p-value used to call those eigens as dominant. This
parameter is used only when parameter 'num.eigen' is NULL. Here,
p-value is calcualted to assess how likely the observed relative
eigenexpression are more than the maximum relative eigenexpression
calculated from permutated matrix}

\item{signif}{the singificance to return. It can be either "pval" for
using the p-value as the gene significance, or "fdr" for using the fdr
as the gene significance}

\item{orient.permutation}{the orientation of matrix being permutated.
It can be either "row" to permutate values within each row, or "column"
to permutate values within each column, or "both" to permutate values
both within rows and columns. Notably, when using the p-value as the
gene significance, it is always to permutate values within each row.}

\item{num.permutation}{an integer specifying how many permutations are
used}

\item{fdr.procedure}{the procedure to adjust the fdr. To ensure that
the high distance statistic the more significance, the fdr should be
adjusted either using "stepup" for step-up procedure (from the most
significant to the least significant) or using "stepdown" for step-down
procedure (from the least significant to the most significant)}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
a vector storing gene significance
}
\description{
\code{dSVDsignif} is supposed to obtain gene signficance from the given
gene-sample matrix according to singular value decomposition
(SVD)-based method. The method includes: 1) singular value
decomposition of the input matrix; 2) determination of the eigens in
consideration (if not given); 3) construction of the gene-specific
project vector based on the considered eigens; 4) calculation of the
distance statistic from the projection vector to zero point vector; and
5) based on distance statistic to obtain the gene significance.
}
\note{
none
}
\examples{
\dontrun{
# 1) generate data with an iid matrix of 1000 x 9
data <- cbind(matrix(rnorm(1000*3,mean=0,sd=1), nrow=1000, ncol=3),
matrix(rnorm(1000*3,mean=0.5,sd=1), nrow=1000, ncol=3),
matrix(rnorm(1000*3,mean=-0.5,sd=1), nrow=1000, ncol=3))

# 2) calculate the significance according to SVD
# using "fdr" significance
fdr <- dSVDsignif(data, signif="fdr", num.permutation=10)
# using "pval" significance
pval <- dSVDsignif(data, signif="pval", num.permutation=10)
}
}
\seealso{
\code{\link{dFDRscore}}
}
