dmtools <img src='man/figures/logo.png' align="right" height="170" />
=====================================================================

[![CRAN
status](https://www.r-pkg.org/badges/version/dmtools)](https://CRAN.R-project.org/package=dmtools)
[![Build
Status](https://travis-ci.com/chachabooms/dmtools.svg?token=pmH5ZxVz4xaZTjx5TDKs&branch=master)](https://travis-ci.com/chachabooms/dmtools)
[![codecov](https://codecov.io/gh/chachabooms/dmtools/branch/master/graph/badge.svg?token=AEKUFWUUXZ)](https://codecov.io/gh/chachabooms/dmtools)

Installation
------------

    install.packages("dmtools")

    # dev-version
    devtools::install_github("chachabooms/dmtools")

    library(dmtools)

Overview
--------

For checking the dataset from EDC in clinical trials. Notice, your
dataset should have a postfix( \_v1 ) or a prefix( v1\_ ) in the names
of variables. Column names should be unique.

-   `date()` - create object date, for check dates in the dataset
-   `lab()` - create object lab, for check lab results
-   `short()` - create object short to transform the dataset(different
    events in one column)
-   `check()` - check objects
-   `get_result()` - get the final result of object
-   `choose_test()` - filter the final result of `check()`
-   `check_sites()` - check objects of different sites
-   `test_sites()` - filter the final result of `check_sites()`
-   `rename_dataset()` - rename dataset

Usage
-----

For example, you want to check laboratory values, you need to create the
excel table like in the example.

-   AGELOW - number, &gt;= number
-   AGEHIGH - if none, type Inf, &lt;= number  
-   SEX - for both sex, use `|`
-   LBTEST - What was the lab test name?
-   LBORRES - What was the result of the result lab test?
-   LBNDIND - How \[did/do\] the reported values compare within the
    \[reference/normal/expected\] range?
-   LBORNRLO - What was the lower limit of the reference range for this
    lab test, &gt;=
-   LBORNRHI - What was the high limit of the reference range for this
    lab test, &lt;=

<table>
<caption>lab reference ranges</caption>
<thead>
<tr class="header">
<th style="text-align: right;">AGELOW</th>
<th style="text-align: right;">AGEHIGH</th>
<th style="text-align: left;">SEX</th>
<th style="text-align: left;">LBTEST</th>
<th style="text-align: left;">LBORRES</th>
<th style="text-align: left;">LBNDIND</th>
<th style="text-align: left;">LBORNRLO</th>
<th style="text-align: left;">LBORNRHI</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: right;">18</td>
<td style="text-align: right;">45</td>
<td style="text-align: left;">f|m</td>
<td style="text-align: left;">gluc</td>
<td style="text-align: left;">gluc</td>
<td style="text-align: left;">gluc_res</td>
<td style="text-align: left;">3.9</td>
<td style="text-align: left;">5.9</td>
</tr>
<tr class="even">
<td style="text-align: right;">18</td>
<td style="text-align: right;">45</td>
<td style="text-align: left;">m</td>
<td style="text-align: left;">ast</td>
<td style="text-align: left;">ast</td>
<td style="text-align: left;">ast_res</td>
<td style="text-align: left;">0</td>
<td style="text-align: left;">42</td>
</tr>
<tr class="odd">
<td style="text-align: right;">18</td>
<td style="text-align: right;">45</td>
<td style="text-align: left;">f</td>
<td style="text-align: left;">ast</td>
<td style="text-align: left;">ast</td>
<td style="text-align: left;">ast_res</td>
<td style="text-align: left;">0</td>
<td style="text-align: left;">39</td>
</tr>
</tbody>
</table>

<table>
<caption>dataset</caption>
<thead>
<tr class="header">
<th style="text-align: left;">id</th>
<th style="text-align: left;">age</th>
<th style="text-align: left;">sex</th>
<th style="text-align: left;">gluc_v1</th>
<th style="text-align: left;">gluc_res_v1</th>
<th style="text-align: left;">ast_v2</th>
<th style="text-align: left;">ast_res_v2</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;">01</td>
<td style="text-align: left;">19</td>
<td style="text-align: left;">f</td>
<td style="text-align: left;">5.5</td>
<td style="text-align: left;">norm</td>
<td style="text-align: left;">30</td>
<td style="text-align: left;">norm</td>
</tr>
<tr class="even">
<td style="text-align: left;">02</td>
<td style="text-align: left;">20</td>
<td style="text-align: left;">m</td>
<td style="text-align: left;">4.1</td>
<td style="text-align: left;">NA</td>
<td style="text-align: left;">48</td>
<td style="text-align: left;">norm</td>
</tr>
<tr class="odd">
<td style="text-align: left;">03</td>
<td style="text-align: left;">22</td>
<td style="text-align: left;">m</td>
<td style="text-align: left;">9.7</td>
<td style="text-align: left;">norm</td>
<td style="text-align: left;">31</td>
<td style="text-align: left;">norm</td>
</tr>
</tbody>
</table>

    # "norm" and "no" it is an example, necessary variable for the estimate, get from the dataset
    refs <- system.file("labs_refer.xlsx", package = "dmtools")
    obj_lab <- lab(refs, id, age, sex, "norm", "no")
    obj_lab <- obj_lab %>% check(df)

    # ok - analysis, which has a correct estimate of the result
    obj_lab %>% choose_test("ok")
    #>   id age sex LBTEST LBTESCD VISIT LBORNRLO LBORNRHI LBORRES LBNRIND
    #> 1 01  19   f   gluc    gluc   _v1      3.9      5.9     5.5    norm
    #> 2 01  19   f    ast     ast   _v2      0.0     39.0      30    norm
    #> 3 03  22   m    ast     ast   _v2      0.0     42.0      31    norm
    #>   RES_TYPE_NUM IND_EXPECTED
    #> 1          5.5         norm
    #> 2         30.0         norm
    #> 3         31.0         norm

    # mis - analysis, which has an incorrect estimate of the result
    obj_lab %>% choose_test("mis")
    #>   id age sex LBTEST LBTESCD VISIT LBORNRLO LBORNRHI LBORRES LBNRIND
    #> 1 02  20   m    ast     ast   _v2      0.0     42.0      48    norm
    #> 2 03  22   m   gluc    gluc   _v1      3.9      5.9     9.7    norm
    #>   RES_TYPE_NUM IND_EXPECTED
    #> 1         48.0           no
    #> 2          9.7           no

    # skip - analysis, which has an empty value of the estimate
    obj_lab %>% choose_test("skip")
    #>   id age sex LBTEST LBTESCD VISIT LBORNRLO LBORNRHI LBORRES LBNRIND
    #> 1 02  20   m   gluc    gluc   _v1      3.9      5.9     4.1    <NA>
    #>   RES_TYPE_NUM IND_EXPECTED
    #> 1          4.1         <NA>

<table>
<caption>strange_dataset</caption>
<thead>
<tr class="header">
<th style="text-align: left;">id</th>
<th style="text-align: left;">age</th>
<th style="text-align: left;">sex</th>
<th style="text-align: left;">gluc_v1</th>
<th style="text-align: left;">gluc_res_v1</th>
<th style="text-align: left;">ast_v2</th>
<th style="text-align: left;">ast_res_v2</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;">01</td>
<td style="text-align: left;">19</td>
<td style="text-align: left;">f</td>
<td style="text-align: left;">5,5</td>
<td style="text-align: left;">norm</td>
<td style="text-align: left;">&lt; 5</td>
<td style="text-align: left;">norm</td>
</tr>
<tr class="even">
<td style="text-align: left;">02</td>
<td style="text-align: left;">20</td>
<td style="text-align: left;">m</td>
<td style="text-align: left;">4,1</td>
<td style="text-align: left;">NA</td>
<td style="text-align: left;">48</td>
<td style="text-align: left;">norm</td>
</tr>
<tr class="odd">
<td style="text-align: left;">03</td>
<td style="text-align: left;">22</td>
<td style="text-align: left;">m</td>
<td style="text-align: left;">9,7</td>
<td style="text-align: left;">norm</td>
<td style="text-align: left;">31</td>
<td style="text-align: left;">norm</td>
</tr>
</tbody>
</table>

    # dmtools can work with the dataset as strange_df
    obj_lab <- obj_lab %>% check(strange_df)

    # dmtools can understand the value with a comma like 6,6 
    obj_lab %>% choose_test("ok")
    #>   id age sex LBTEST LBTESCD VISIT LBORNRLO LBORNRHI LBORRES LBNRIND
    #> 1 01  19   f   gluc    gluc   _v1      3.9      5.9     5,5    norm
    #> 2 03  22   m    ast     ast   _v2      0.0     42.0      31    norm
    #>   RES_TYPE_NUM IND_EXPECTED
    #> 1          5.5         norm
    #> 2         31.0         norm

    # Notice, if dmtools can't understand the value of lab_vals e.g. < 5, it puts Inf in the vals_to_dbl
    obj_lab %>% choose_test("mis")
    #>   id age sex LBTEST LBTESCD VISIT LBORNRLO LBORNRHI LBORRES LBNRIND
    #> 1 01  19   f    ast     ast   _v2      0.0     39.0     < 5    norm
    #> 2 02  20   m    ast     ast   _v2      0.0     42.0      48    norm
    #> 3 03  22   m   gluc    gluc   _v1      3.9      5.9     9,7    norm
    #>   RES_TYPE_NUM IND_EXPECTED
    #> 1          Inf           no
    #> 2         48.0           no
    #> 3          9.7           no

    obj_lab %>% choose_test("skip")
    #>   id age sex LBTEST LBTESCD VISIT LBORNRLO LBORNRHI LBORRES LBNRIND
    #> 1 02  20   m   gluc    gluc   _v1      3.9      5.9     4,1    <NA>
    #>   RES_TYPE_NUM IND_EXPECTED
    #> 1          4.1         <NA>
