% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmds.R
\name{bmds_get_x_mode}
\alias{bmds_get_x_mode}
\title{Posterior mode latent configuration in Bayesian multidimensional scaling (BMDS).}
\usage{
bmds_get_x_mode(D, res, p.i, min_p, max_p, start, end)
}
\arguments{
\item{D}{Observed dissimilarities (provided as a distance matrix).}

\item{res}{Results of a BMDS analysis as obtained with the
\code{\link{bmds}} function.}

\item{p.i}{A length-one numeric vector providing the index of the solution to
use.}

\item{min_p}{A length-one numeric vector providing the minimum value of the
latent space dimension to use.}

\item{max_p}{A length-one numeric vector providing the maximum value
of the latent space dimension to use.}

\item{start}{A length-one numeric vector providing the iteration
number to start from.}

\item{end}{A length-one numeric vector providing the iteration
number where to end.}
}
\value{
A real matrix containing the posterior mode latent configuration.
}
\description{
\code{bmds_get_x_mode} returns the latent configuration that produced the
  largest posterior value during the MCMC.
}
\examples{
\dontrun{
# Airline Distances Between Cities
airline <- read.csv(file = system.file("extdata", "airline.csv",
  package = "dmbc"))
airline.nm <- airline[, 1]
airline <- airline[, 2:31]
colnames(airline) <- airline.nm
airline <- as.dist(airline)

min_p <- 1
max_p <- 4
burnin <- 200
nsim <- 1000
totiter <- burnin + nsim

airline.mds <- cmdscale(airline, max_p)
airline.bmds <- bmds(airline, min_p, max_p, burnin, nsim)

opar <- par(mfrow = c(1, 2))
plot(min_p:max_p, airline.bmds$mdsIC$mdsic, type = "b",
  main = "MDS Information Criterion", xlab = "p", ylab = "MDSIC")
MDSICmin <- which.min(airline.bmds$mdsIC$mdsic)
points((min_p:max_p)[MDSICmin], airline.bmds$mdsIC$mdsic[MDSICmin],
  col = "red", pch = 10, cex = 1.75, lwd = 1.5)

airline.bmds.x.mode <- bmds_get_x_mode(airline, airline.bmds, MDSICmin,
  min_p, max_p, start = (burnin + 1), end = totiter)
airline.bmds.d <- dist(airline.bmds.x.mode)
airline.mds.d <- dist(airline.mds[, 1:((min_p:max_p)[MDSICmin])])
plot(airline, airline.bmds.d, type = "n", xlab = "observed",
  ylab = "estimated", main = "Airline Distances \n Between Cities",
  xlim = c(0, max(airline, airline.bmds.d)),
  ylim = c(0, max(airline, airline.bmds.d)))
abline(0, 1, lty = 2, col = "gray")
points(airline, airline.mds.d, pch = 19, col = "cyan", cex = .5)
points(airline, airline.bmds.d, pch = 19, col = "magenta", cex = .5)
legend(x = "bottomright", legend = c("Classical MDS", "Bayesian MDS"),
  pch = c(19, 19), col = c("cyan", "magenta"))
par(opar)
}
}
\seealso{
\code{\link{bmds}} for (one-way) Bayesian (metric) multidimensional
  scaling.
}
\author{
Sergio Venturini \email{sergio.venturini@unito.it}
}
