% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{find_class}
\alias{find_class}
\title{Extract variable names or indices of a specific class}
\usage{
find_class(
  df,
  type = c("numerical", "categorical", "categorical2"),
  index = TRUE
)
}
\arguments{
\item{df}{a data.frame or objects inheriting from data.frame}

\item{type}{character. Defines a group of classes to be searched.
"numerical" searches for "numeric" and "integer" classes,
"categorical" searches for "factor" and "ordered" classes.
"categorical2" adds "character" class to "categorical".}

\item{index}{logical. If TRUE is return numeric vector that is variables index.
and if FALSE is return character vector that is variables name.
defalut is TRUE.}
}
\value{
character vector or numeric vector.
The meaning of vector according to data type is as follows.
\itemize{
\item character vector : variables name
\item numeric vector : variables index
}
}
\description{
The find_class() extracts variable information having a
certain class from an object inheriting data.frame.
}
\examples{
\dontrun{
# data.frame
find_class(iris, "numerical")
find_class(iris, "numerical", index = FALSE)
find_class(iris, "categorical")
find_class(iris, "categorical", index = FALSE)

# tbl_df
find_class(ISLR::Carseats, "numerical")
find_class(ISLR::Carseats, "numerical", index = FALSE)
find_class(ISLR::Carseats, "categorical")
find_class(ISLR::Carseats, "categorical", index = FALSE)

# type is "categorical2"
iris2 <- data.frame(iris, char = "chars",
                    stringsAsFactors = FALSE)
find_class(iris2, "categorical", index = FALSE)
find_class(iris2, "categorical2", index = FALSE)
}
}
\seealso{
\code{\link{get_class}}.
}
