% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcommunity.R
\name{rcommunity}
\alias{rcommunity}
\alias{rspcommunity}
\title{Random communities}
\usage{
rcommunity(
  n,
  size = sum(abd),
  prob = NULL,
  abd = NULL,
  bootstrap = c("Chao2015", "Marcon2012", "Chao2013"),
  species_number = 300,
  distribution = c("lnorm", "lseries", "geom", "bstick"),
  sd_lnorm = 1,
  prob_geom = 0.1,
  fisher_alpha = 40,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  check_arguments = TRUE
)

rspcommunity(
  n,
  size = sum(abd),
  prob = NULL,
  abd = NULL,
  bootstrap = c("Chao2015", "Marcon2012", "Chao2013"),
  species_number = 300,
  distribution = c("lnorm", "lseries", "geom", "bstick"),
  sd_lnorm = 1,
  prob_geom = 0.1,
  fisher_alpha = 40,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  spatial = c("Binomial", "Thomas"),
  thomas_scale = 0.2,
  thomas_mu = 10,
  win = spatstat.geom::owin(),
  species_names = NULL,
  weight_distribution = c("Uniform", "Weibull", "Exponential"),
  w_min = 1,
  w_max = 1,
  w_mean = 15,
  weibull_scale = 20,
  weibull_shape = 2,
  check_arguments = TRUE
)
}
\arguments{
\item{n}{the number of communities to draw.}

\item{size}{the number of individuals to draw in each community.}

\item{prob}{a numeric vector containing probabilities.}

\item{abd}{a numeric vector containing abundances.}

\item{bootstrap}{the method used to obtain the probabilities to generate
bootstrapped communities from observed abundances.
If "Marcon2012", the probabilities are simply the abundances divided by the total
number of individuals \insertCite{Marcon2012a}{divent}.
If "Chao2013" or "Chao2015" (by default), a more sophisticated approach is used
(see \link{as_probabilities}) following \insertCite{Chao2013;textual}{divent} or
\insertCite{Chao2015;textual}{divent}.}

\item{species_number}{the number of species.}

\item{distribution}{The distribution of species abundances.
May be "lnorm" (log-normal), "lseries" (log-series), "geom" (geometric) or
"bstick" (broken stick).}

\item{sd_lnorm}{the simulated log-normal distribution standard deviation.
This is the standard deviation on the log scale.}

\item{prob_geom}{the proportion of resources taken by successive species
of the geometric distribution.}

\item{fisher_alpha}{Fisher's \eqn{\alpha} in the log-series distribution.}

\item{coverage_estimator}{an estimator of sample coverage used by \link{coverage}.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{spatial}{the spatial distribution of points.
May be "Binomial" (a completely random point pattern except for its fixed number of points) or
"Thomas" for a clustered point pattern with parameters \code{scale} and \code{mu}.}

\item{thomas_scale}{in Thomas point patterns, the standard deviation of random displacement
(along each coordinate axis) of a point from its cluster center.}

\item{thomas_mu}{in Thomas point patterns, the mean number of points per cluster.
The intensity of the Poisson process of cluster centers is calculated as
the number of points (\code{size}) per area divided by \code{thomas_mu}.}

\item{win}{the window containing the point pattern.
It is an \link[spatstat.geom:owin]{spatstat.geom::owin} object.
Default is a 1x1 square.}

\item{species_names}{a vector of characters or of factors containing the possible species names.}

\item{weight_distribution}{the distribution of point weights.
By default, all weight are 1.
May be "uniform" for a uniform distribution between \code{w_min} and \code{w_max},
"weibull" with parameters \code{w_min}, \code{weibull_scale} and \code{shape} or
"exponential" with parameter \code{w_mean}.}

\item{w_min}{the minimum weight in a uniform, exponential or Weibull distribution.}

\item{w_max}{the maximum weight in a uniform distribution.}

\item{w_mean}{the mean weight in an exponential distribution
(i.e. the negative of the inverse of the decay rate).}

\item{weibull_scale}{the scale parameter in a Weibull distribution.}

\item{weibull_shape}{the shape parameter in a Weibull distribution.}
}
\value{
\code{rcommunity()} returns an object of class \link{abundances}.

\code{rspcommunity()} returns either a spatialized community,
which is a \link[dbmss:wmppp]{dbmss::wmppp} object , with \code{PointType}
values as species names if \code{n}=1 or an object of class ppplist
(see \link[spatstat.geom:solist]{spatstat.geom::solist})  if \code{n}>1.
}
\description{
\code{rcommunity()} draws random communities according to a probability distribution.
\code{rspcommunity()} extends it by spatializing the random communities.
}
\details{
Communities of fixed \code{size} are drawn in a multinomial distribution according
to the distribution of probabilities provided by \code{prob}.
An abundance vector \code{abd} may be used instead of probabilities,
then \code{size} is by default the total number of individuals in the vector.
Random communities can be built by drawing in a multinomial law following
\insertCite{Marcon2012a;textual}{divent}, or trying to estimate the
distribution of the actual community with \link{probabilities}.
If \code{bootstrap} is "Chao2013", the distribution is estimated by a single
parameter model and unobserved species are given equal probabilities.
If \code{bootstrap} is "Chao2015", a two-parameter model is used and unobserved
species follow a geometric distribution.

Alternatively, the probabilities may be drawn following a classical
distribution: either lognormal ("lnorm")  \insertCite{Preston1948}{divent}
with given standard deviation (\code{sd_lnorm}; note that the mean is actually
a normalizing constant. Its value is set equal to 0 for the simulation of
the normal distribution of unnormalized log-abundances), log-series ("lseries")
\insertCite{Fisher1943}{divent} with parameter \code{fisher_alpha}, geometric
("geom") \insertCite{Motomura1932}{divent} with parameter \code{prob_geom},
or broken stick ("bstick") \insertCite{MacArthur1957}{divent}.
The number of simulated species is fixed by \code{species_number}, except for
"lseries" where it is obtained from \code{fisher_alpha} and \code{size}:
\eqn{S = \alpha \ln(1 + size / \alpha)}.
Note that the probabilities are drawn once only.
If the number of communities to draw, \code{n}, is greater than 1, then they are
drawn in a multinomial distribution following these probabilities.

Log-normal, log-series and broken-stick distributions are stochastic.
The geometric distribution is completely determined by its parameters.

Spatialized communities include the location of individuals in a window,
in a \link[dbmss:wmppp]{dbmss::wmppp} object.
Several point processes are available, namely binomial (points are uniformly
distributed in the window) and \insertCite{Thomas1949;textual}{divent}, which
is clustered.

Point weights, that may be for instance the size of the trees in a forest
community, can be uniform, follow a Weibull or a negative exponential distribution.
The latter describe well the diameter distribution of trees in a forest
\insertCite{Rennolls1985,Turner2004}{divent}.
}
\examples{
# Generate a community made of 100000 individuals among 300 species and fit it
abundances <- rcommunity(n = 1, size = 1E5,
  species_number = 300, distribution = "lnorm")
autoplot(abundances)
X <- rspcommunity(1, size = 30, species_number = 5)
autoplot(X)

}
\references{
\insertAllCited{}
}
