% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accum_hill.R
\name{accum_hill}
\alias{accum_hill}
\alias{accum_tsallis}
\alias{accum_tsallis.numeric}
\alias{accum_tsallis.abundances}
\alias{accum_hill.numeric}
\alias{accum_hill.abundances}
\title{Diversity Accumulation of a Community}
\usage{
accum_tsallis(x, ...)

\method{accum_tsallis}{numeric}(
  x,
  q = 0,
  levels = seq_len(sum(x)),
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("rarefy", "jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  n_simulations = 0,
  alpha = 0.05,
  show_progress = TRUE,
  ...,
  check_arguments = TRUE
)

\method{accum_tsallis}{abundances}(
  x,
  q = 0,
  levels = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("rarefy", "jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  n_simulations = 0,
  alpha = 0.05,
  show_progress = TRUE,
  ...,
  check_arguments = TRUE
)

accum_hill(x, ...)

\method{accum_hill}{numeric}(
  x,
  q = 0,
  levels = seq_len(sum(x)),
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("rarefy", "jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  n_simulations = 0,
  alpha = 0.05,
  show_progress = TRUE,
  ...,
  check_arguments = TRUE
)

\method{accum_hill}{abundances}(
  x,
  q = 0,
  levels = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("rarefy", "jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  n_simulations = 0,
  alpha = 0.05,
  show_progress = TRUE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object, that may be a numeric vector containing abundances or probabilities,
or an object of class \link{abundances}  or \link{probabilities}.}

\item{...}{Unused.}

\item{q}{The order of diversity.}

\item{levels}{The levels, i.e. the sample sizes of interpolation or
extrapolation: a vector of integer values.}

\item{probability_estimator}{A string containing one of the possible estimators
of the probability distribution (see \link{probabilities}).
Used only for extrapolation.}

\item{unveiling}{A string containing one of the possible unveiling methods
to estimate the probabilities of the unobserved species (see \link{probabilities}).
Used only for extrapolation.}

\item{richness_estimator}{An estimator of richness to evaluate the total number of species,
see \link{div_richness}. Used for interpolation and extrapolation.}

\item{jack_alpha}{The risk level, 5\% by default, used to optimize the jackknife order.}

\item{jack_max}{The highest jackknife order allowed. Default is 10.}

\item{coverage_estimator}{An estimator of sample coverage used by \link{coverage}.}

\item{n_simulations}{The number of simulations used to estimate the confidence envelope.}

\item{alpha}{The risk level, 5\% by default.}

\item{show_progress}{If TRUE, a progress bar is shown during long computations.}

\item{check_arguments}{If \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}
}
\value{
A tibble with the site names, the estimators used and the accumulated entropy
or diversity at each level of sampling effort.
}
\description{
Diversity and Entropy Accumulation Curves represent the accumulation of
entropy with respect to the sample size.
}
\details{
\code{accum_hill()} or \code{accum_tsallis()} estimate the diversity or entropy accumulation
curve of a distribution.
See \link{ent_tsallis} for details about the computation of entropy at each level
of interpolation and extrapolation.

In accumulation curves, extrapolation is done by estimating the asymptotic
distribution of the community and estimating entropy at different levels
by interpolation.

Interpolation and extrapolation of integer orders of diversity are from
\insertCite{Chao2014;textual}{divent}.
The asymptotic richness is adjusted so that the extrapolated part of the
accumulation joins the observed value at the sample size.

"accumulation" objects can be plotted.
They generalize the classical Species Accumulation Curves (SAC) which are
diversity accumulation of order \eqn{q=0}.
}
\examples{
# Paracou 6 subplot 1
autoplot(accum_hill(paracou_6_abd[1, ]))

}
\references{
\insertAllCited{}
}
