% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nycflights13-sql.R
\name{nycflights13_create_sqlite}
\alias{nycflights13_create_sqlite}
\title{Create an in-memory SQLite database for testing}
\usage{
nycflights13_create_sqlite(location = ":memory:", ...)
}
\arguments{
\item{location}{where to store the database}

\item{...}{additional parameters to connect to a database (most are passed on
to \code{\link{nycflights13_create_sql}})}
}
\value{
RSQLiteConnection
}
\description{
Create an in-memory SQLite database for testing
}
\examples{
\donttest{
if (check_for_pkg("RSQLite", message)) {
  con <- nycflights13_create_sqlite()

  DBI::dbGetQuery(
    con,
    "SELECT year, month, day, carrier, flight, tailnum FROM flights LIMIT 10"
  )

  DBI::dbDisconnect(con)
}
}
}
