% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneralisedExtremeValue.R
\name{random.GEV}
\alias{random.GEV}
\title{Draw a random sample from a GEV distribution}
\usage{
\method{random}{GEV}(x, n = 1L, drop = TRUE, ...)
}
\arguments{
\item{x}{A \code{GEV} object created by a call to \code{\link[=GEV]{GEV()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
In case of a single distribution object or \code{n = 1}, either a numeric
vector of length \code{n} (if \code{drop = TRUE}, default) or a \code{matrix} with \code{n} columns
(if \code{drop = FALSE}).
}
\description{
Draw a random sample from a GEV distribution
}
\examples{

set.seed(27)

X <- GEV(1, 2, 0.1)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
