% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{fit_mle}
\alias{fit_mle}
\title{Fit a distribution to data}
\usage{
fit_mle(d, x, ...)
}
\arguments{
\item{d}{An object. The package provides methods for distribution
objects such as those from \code{\link[=Normal]{Normal()}} or \code{\link[=Binomial]{Binomial()}} etc.}

\item{x}{A vector of data to compute the likelihood.}

\item{...}{Arguments passed to methods. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A distribution (the same kind as \code{d}) where the parameters
are the MLE estimates based on \code{x}.
}
\description{
Generic function for fitting maximum-likelihood estimates (MLEs) of
a distribution based on empirical data.
}
\examples{
X <- Normal()
fit_mle(X, c(-1, 0, 0, 0, 3))
}
