% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weibull.R
\name{random.Weibull}
\alias{random.Weibull}
\title{Draw a random sample from a Weibull distribution}
\usage{
\method{random}{Weibull}(x, n = 1L, ...)
}
\arguments{
\item{x}{A \code{Weibull} object created by a call to \code{\link[=Weibull]{Weibull()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
An integer vector of length \code{n}.
}
\description{
Draw a random sample from a Weibull distribution
}
\examples{

set.seed(27)

X <- Weibull(0.3, 2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

}
\seealso{
Other Weibull distribution: 
\code{\link{cdf.Weibull}()},
\code{\link{pdf.Weibull}()},
\code{\link{quantile.Weibull}()}
}
\concept{Weibull distribution}
