% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{random.Gamma}
\alias{random.Gamma}
\title{Draw a random sample from a Gamma distribution}
\usage{
\method{random}{Gamma}(x, n = 1L, ...)
}
\arguments{
\item{x}{A \code{Gamma} object created by a call to \code{\link[=Gamma]{Gamma()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A numeric vector of length \code{n}.
}
\description{
Draw a random sample from a Gamma distribution
}
\examples{

set.seed(27)

X <- Gamma(5, 2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
