% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Erlang.R
\name{quantile.Erlang}
\alias{quantile.Erlang}
\title{Determine quantiles of an Erlang distribution}
\usage{
\method{quantile}{Erlang}(x, probs, ..., interval = c(0, 1e+06), tol = .Machine$double.eps)
}
\arguments{
\item{x}{An \code{Erlang} object created by a call to \code{\link[=Erlang]{Erlang()}}.}

\item{probs}{A vector of probabilities.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}

\item{interval}{Interval being used to search for the quantile using numerical root finding. Defaults to (0, 1e6)}

\item{tol}{Tolerance of the root finding algorithm. Defaults to \code{.Machine$double.eps}}
}
\value{
A vector of quantiles, one for each element of \code{probs}.
}
\description{
\code{quantile()} is the inverse of \code{cdf()}.
}
\examples{

set.seed(27)

X <- Erlang(5, 2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
