% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beta.R
\name{quantile.Beta}
\alias{quantile.Beta}
\title{Determine quantiles of a Beta distribution}
\usage{
\method{quantile}{Beta}(x, probs, ...)
}
\arguments{
\item{x}{A \code{Beta} object created by a call to \code{\link[=Beta]{Beta()}}.}

\item{probs}{A vector of probabilities.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{probs}.
}
\description{
\code{quantile()} is the inverse of \code{cdf()}.
}
\examples{

set.seed(27)

X <- Beta(1, 2)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

mean(X)
variance(X)
skewness(X)
kurtosis(X)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
