% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uniform.R
\name{pdf.Uniform}
\alias{pdf.Uniform}
\alias{log_pdf.Uniform}
\title{Evaluate the probability mass function of a continuous Uniform distribution}
\usage{
\method{pdf}{Uniform}(d, x, ...)

\method{log_pdf}{Uniform}(d, x, ...)
}
\arguments{
\item{d}{A \code{Uniform} object created by a call to \code{\link[=Uniform]{Uniform()}}.}

\item{x}{A vector of elements whose probabilities you would like to
determine given the distribution \code{d}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of probabilities, one for each element of \code{x}.
}
\description{
Evaluate the probability mass function of a continuous Uniform distribution
}
\examples{

set.seed(27)

X <- Uniform(1, 2)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))

}
