% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NegativeBinomial.R
\name{NegativeBinomial}
\alias{NegativeBinomial}
\title{Create a Negative Binomial distribution}
\usage{
NegativeBinomial(size, p = 0.5)
}
\arguments{
\item{size}{The number of failures (an integer greater than \eqn{0})
until the experiment is stopped. Denoted \eqn{r} below.}

\item{p}{The success probability for a given trial. \code{p} can be any
value in \verb{[0, 1]}, and defaults to \code{0.5}.}
}
\value{
A \code{NegativeBinomial} object.
}
\description{
A generalization of the geometric distribution. It is the number
of successes in a sequence of i.i.d. Bernoulli trials before
a specified number (\eqn{r}) of failures occurs.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail and much greater clarity.

In the following, let \eqn{X} be a Negative Binomial random variable with
success probability \code{p} = \eqn{p}.

\strong{Support}: \eqn{\{0, 1, 2, 3, ...\}}

\strong{Mean}: \eqn{\frac{p r}{1-p}}

\strong{Variance}: \eqn{\frac{pr}{(1-p)^2}}

\strong{Probability mass function (p.m.f)}:

\deqn{
     f(k) = {k + r - 1 \choose k} \cdot (1-p)^r p^k
  }{
     f(k) = (k+r-1)!/(k!(r-1)!) (1-p)^r p^k
  }

\strong{Cumulative distribution function (c.d.f)}:

Omitted for now.

\strong{Moment generating function (m.g.f)}:

\deqn{
     \left(\frac{1-p}{1-pe^t}\right)^r, t < -\log p
  }{
     \frac{(1-p)^r}{(1-pe^t)^r}, t < -\log p
  }
}
\examples{

set.seed(27)

X <- NegativeBinomial(10, 0.3)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other discrete distributions: 
\code{\link{Bernoulli}()},
\code{\link{Binomial}()},
\code{\link{Categorical}()},
\code{\link{Geometric}()},
\code{\link{HyperGeometric}()},
\code{\link{Multinomial}()},
\code{\link{Poisson}()}
}
\concept{discrete distributions}
