% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cauchy.R
\name{random.Cauchy}
\alias{random.Cauchy}
\title{Draw a random sample from a Cauchy distribution}
\usage{
\method{random}{Cauchy}(d, n = 1L, ...)
}
\arguments{
\item{d}{A \code{Cauchy} object created by a call to \code{\link[=Cauchy]{Cauchy()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A numeric vector of length \code{n}.
}
\description{
Draw a random sample from a Cauchy distribution
}
\examples{

set.seed(27)

X <- Cauchy(10, 0.2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 2)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
